/**********************************************************************
 * Copyright (c) 2007, 2010 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ClassPackageNameLabelAdapter.java,v 1.3 2010/06/02 21:06:35 jcayne Exp $
 * 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextProvider;

public class ClassPackageNameLabelAdapter extends ColumnLabelAdapter {

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return null;
		if (element instanceof TRCPackage) {
			TRCPackage pack = (TRCPackage) element;
			IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.PACKAGE_NAME);
			return createImage(formatter.getDisplayImageByElement(pack.getName(), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		} else if (element instanceof TRCClass) {
			TRCClass cls = (TRCClass) element;
			IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.CLASS_NAME);
			return createImage(formatter.getDisplayImageByElement(cls.getName(), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		} else if (element instanceof TRCObject) {
			return TracePluginImages.getImage(TracePluginImages.IMG_CLASS_OBJ);
		} else if (element instanceof TRCObjectValue) {
			return TracePluginImages.getImage(TracePluginImages.IMG_OBJ);
		}
		return null;
	}

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		String displayString = "";
		if (element instanceof TRCPackage) {
			TRCPackage pack = (TRCPackage) element;
			displayString = getDisplyStringFromMap(pack);
			if (displayString == null) {
				IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.PACKAGE_NAME);
				displayString = formatter.getDisplayStringFromElement(pack.getName(), pack, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				displayStringMap.put(pack, displayString);
			}
		} else if (element instanceof TRCClass) {
			TRCClass cls = (TRCClass) element;
			displayString = getDisplyStringFromMap(cls);
			if (displayString == null) {
				IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.CLASS_NAME);
				displayString = formatter.getDisplayStringFromElement(cls.getName(), cls, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				displayStringMap.put(cls, displayString);
			}
		} else if (element instanceof TRCObject) {
			// Object Name followed by TPTP ID
			TRCObject objval = (TRCObject) element;
			displayString = objval.getIsA().getName() + " (id=" + objval.getId() + ")"; //$NON-NLS-1$ //$NON-NLS-2$
		} else if (element instanceof TRCObjectValue) {
			TRCObjectValue objval = (TRCObjectValue) element;
			displayString = objval.getStringValue();
			if (displayString == null) {
				IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.OBJECT_NAME);
				displayString = formatter.getDisplayStringFromElement(displayString, objval, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				displayStringMap.put(objval, displayString);
			}
		}
		return displayString;
	}
}
