/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 * 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextAttributes;

public class GenerationsLabelAdapter extends NumberLabelAdapter {

	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage) {
			// TODO stub
			//TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)((TRCPackage) element).retrieveSnapshot();		
			//return new Integer(getAverageAge());
			return new Integer(0);
		}
		if (element instanceof TRCClass) {
			// TODO stub
			//TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)((TRCClass) element).retrieveSnapshot();		
			//return new Integer(getAverageAge());
			return new Integer(0);
		}
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage) {
			// TODO stub
			TRCPackageSnapshot delta = packageSnapshot();
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__TOTAL_INSTANCES);
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES);						
			//return new Integer(delta.getTotalInstances() - delta.getCollectedInstances());
			return new Integer(0);
		}
		if (element instanceof TRCClass) {
			// TODO stub
			TRCClassSnapshot delta = classSnapshot();			
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__TOTAL_INSTANCES);
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__COLLECTED_INSTANCES);						
			//return new Integer(delta.getTotalInstances() - delta.getCollectedInstances());
			return new Integer(0);
		}		
		return null;
	}
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		if (eObj instanceof TRCPackage)
			return TIContextAttributes.PACKAGE_GENERATIONS;
		else if (eObj instanceof TRCClass)
			return TIContextAttributes.CLASS_GENERATIONS;
		else
			return null;
		// TODO call sites
	}			
}
