/**********************************************************************
 * Copyright (c) 2007, 2008 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 * 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextProvider;

public abstract class NumberLabelAdapter extends AbstractNumberColumnLabel {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		String attributeId = getContextAttribute(element, info);
		if (attributeId != null) {
			IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(attributeId);
			if (!info.isDeltaColumn) {
				Number number = getValue(element, info);
				if (number != null) {
					if (info.showPercentage)
						return TString.formatAsPercentage(number.doubleValue() / info.max);
					else
						return formatter.getDisplayStringFromElement(number, element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				}
			} else {
				if (element instanceof TRCPackage
						|| element instanceof TRCClass
						|| element instanceof TRCMethod
						|| element instanceof MethodCallDetails)
					return formatter.getDisplayStringFromElement(getDelta(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			}
		}
		return "";
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (!info.isDeltaColumn) {
			Number delta = getDelta(element, info);
			double d = delta != null ? delta.doubleValue() : 0;
			if (d < 0)
				return TracePluginImages.getImage(TracePluginImages.IMG_DELTADOWN);
			if (d > 0)
				return TracePluginImages.getImage(TracePluginImages.IMG_DELTAUP);
			else {
				String attributeId = getContextAttribute(element, info);
				if (attributeId == null)
					return null;
				IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(attributeId);
				return createImage(formatter.getDisplayImageByElement(getValue(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
			}
		}
		return null;
	}
}
