/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 * 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class PackageNameLabelAdapter extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		TRCPackage pack = Utils.getPackage(element);
		if (pack != null) {
			String displayString = getDisplyStringFromMap(pack);
			if (displayString == null) {
				IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.PACKAGE_NAME);
				displayString = formatter.getDisplayStringFromElement(pack.getName(), pack, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				displayStringMap.put(pack, displayString);
			}
			return displayString;// + " [" + pack.getProcess().getPid() + "]";
		}
		return "";
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		TRCPackage pack = Utils.getPackage(element);
		if (pack != null) {
			IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.PACKAGE_NAME);
			return createImage(formatter.getDisplayImageByElement(pack.getName(), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		}
		return null;
	}

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
