/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadBlockedTimeColumnLabel.java,v 1.1 2007/02/27 18:37:32 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.trace.views.util.internal.ThreadDetails;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class ThreadBlockedTimeColumnLabel extends ThreadDetailsColumnLabel {
	
	protected String getContextAttribute() {
		return IContextAttributes.THREAD_BLOCKED_TIME;
	}

	protected Number getValue(ThreadDetails thread) {
		return new Double(thread.getBlockedTime());
	}	
}
