/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadDetailsColumnLabel.java,v 1.1 2007/02/27 18:37:32 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.util.internal.ThreadDetails;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public abstract class ThreadDetailsColumnLabel extends NumberLabelAdapter {
	
	protected abstract Number getValue(ThreadDetails thread);
	
	protected abstract String getContextAttribute();
	
	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof ThreadDetails) {
			return getValue((ThreadDetails) element);
		}
		return null;
	}

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		Number value = getValue(element, info);
		if (value == null || value.doubleValue() == 0) {
			return "";
		}
		return Utils.formatTime(value.doubleValue());
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		return null;
	}

	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		if (element instanceof ThreadDetails)
			return getContextAttribute();
		else
			return null;
	}
}
