/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 * 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextProvider;

public class ThreadNameLabelAdapter extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		TRCThread thread = (TRCThread) ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.THREAD_NAME);
		return formatter.getDisplayStringFromElement(thread.getName(), thread, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		TRCThread thread = (TRCThread) ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(IContextAttributes.THREAD_NAME);
		return createImage(formatter.getDisplayImageByElement(thread.getName(), thread, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
