/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadStartTimeColumnLabel.java,v 1.1 2007/02/27 18:37:32 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class ThreadStartTimeColumnLabel extends NumberLabelAdapter {
	
	protected Number getValue(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);

		if (eObj instanceof TRCThread)
			return new Double(((TRCThread) eObj).getStartTime());
		else
			return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		return null;
	}

	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		
		if (eObj instanceof TRCThread)
			return IContextAttributes.THREAD_START_TIME;
		else
			return null;
	}	
}
