/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadStateColumnLabel.java,v 1.1 2007/02/27 18:37:32 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.util.internal.ThreadDetails;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

public class ThreadStateColumnLabel extends ColumnLabelAdapter {
	
	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (element instanceof ThreadDetails) {
			switch (((ThreadDetails)element).getState()) {
			case ThreadDetails.RUNNING:
				return UIMessages._Running;
			case ThreadDetails.SLEEPING:
				return UIMessages._Sleeping;
			case ThreadDetails.WAITING:
				return UIMessages._Waiting;
			case ThreadDetails.BLOCKED:
				return UIMessages._Blocked;
			case ThreadDetails.DEADLOCK:
				return UIMessages._Deadlocked;
			case ThreadDetails.STOPPED:
				return UIMessages._Stopped;
			}
		}
		return UIMessages._Unknown;
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		return null;
	}

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}	
}
