/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TotalInstancesLabelAdapter.java,v 1.1 2007/02/27 18:37:32 ewchan Exp $
 * 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.TotalInstancesColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextProvider;

public class TotalInstancesLabelAdapter extends TotalInstancesColumnLabel {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {

		String attributeId = getContextAttribute(element, info);
		if (attributeId == null)
			return "";
		IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(attributeId);
		if (!info.isDeltaColumn) {
			if (info.showPercentage)
				return TString.formatAsPercentage(getValue(element, info).doubleValue() / info.max);
			else
				return formatter.getDisplayStringFromElement(getValue(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		} else {
			if (element instanceof TRCPackage
					|| element instanceof TRCClass
					|| element instanceof TRCMethod
					|| element instanceof MethodCallDetails)
				return formatter.getDisplayStringFromElement(getDelta(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			else
				return "";
		}
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (!info.isDeltaColumn) {
			Number delta = getDelta(element, info);
			double d = delta != null ? delta.doubleValue() : 0;
			if (d < 0)
				return TracePluginImages.getImage(TracePluginImages.IMG_DELTADOWN);
			if (d > 0)
				return TracePluginImages.getImage(TracePluginImages.IMG_DELTAUP);
			else {
				String attributeId = getContextAttribute(element, info);
				if (attributeId == null)
					return null;
				IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider(attributeId);
				return createImage(formatter.getDisplayImageByElement(getValue(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
			}
		}
		return null;
	}
}
