/*****************************************************************************
 * Copyright (c) 2007, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: ITimeDataProvider.java,v 1.3 2010/05/18 20:41:46 jwest Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

public interface ITimeDataProvider {

	double getSelectedTime();

	double getBeginTime();

	double getEndTime();

	/** Refers to the time at which thread data begins in the graph*/
	double getMinTime();

	/** Refers to the time at which thread data (currently) ends in the graph */
	double getMaxTime();

	/** Refers to the start of the viewpoint (what part of the graph the user is currently viewing) in the graph */
	double getTime0();

	/** Refers to the end of the viewpoint (what part of the graph the user is currently viewing) in the graph */
	double getTime1();

	double getMinTimeInterval();

	void setStartFinishTime(double time0, double time1);

	void setSelectedTime(double time, boolean ensureVisible);

	void resetStartFinishTime();

	int getNameSpace();

	void setNameSpace(int width);

	int getTimeSpace();
}
