/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: LegendCtrl.java,v 1.2 2007/02/27 18:37:36 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

public class LegendCtrl extends TraceCtrl {

	static private String _names[];
	private Rectangle _rect0 = new Rectangle(0, 0, 0, 0);

	public LegendCtrl(Composite parent, TraceColorScheme colors) {
		super(parent, colors);
	}
	
	static private String [] getNames() {
		if (null == _names) {
			String names[] = {
					UIMessages._Unknown, // "Unknown",
					UIMessages._Running, // "Running",
					UIMessages._Sleeping, // "Sleeping",
					UIMessages._Waiting, // "Waiting",
					UIMessages._Blocked, // "Blocked",
					UIMessages._Deadlocked, // "Deadlock",
					UIMessages._Stopped, // "Stopped",
			};
			_names = names;
		}
		return _names;
	}

	void paint(Rectangle rect, PaintEvent e) {
		GC gc = e.gc;
		gc.setBackground(_colors.getColor(TraceColorScheme.LEGEND_BACKGROUND));
		gc.fillRectangle(rect);
		// draw legend rect
		Utils.init(_rect0, rect);
		//gc.setForeground(_colors.getColor(TraceColorScheme.LEGEND_FOREGROUND));
		//gc.drawRectangle(_rect0.x, _rect0.y, _rect0.width - 1, _rect0.height - 1);
		//gc.drawRoundRectangle(_rect0.x, _rect0.y, _rect0.width - 1, _rect0.height - 1, 5, 5);
		// draw legend elements
		int idx = 0;
		String names[] = getNames();
		_rect0.x += 4;
		_rect0.y += 4;
		while (idx < names.length && _rect0.x < rect.x + rect.width) {
			Point size = gc.stringExtent(names[idx]);
			_rect0.width = 16;
			_rect0.height = size.y;
			Utils.drawState(_colors, idx, _rect0, gc, false, true, false);
			_rect0.x += _rect0.width + 2;
			_rect0.width = size.x;
			gc.setForeground(_colors.getColor(TraceColorScheme.LEGEND_FOREGROUND));
			Utils.drawText(gc, names[idx], _rect0, true);
			_rect0.x += _rect0.width + 8;
			idx++;
		}
	}
}
