/*****************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: MonitorCallStackToolTipCreater.java,v 1.2 2008/04/16 15:08:45 jkubasta Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorCallDetails;

public class MonitorCallStackToolTipCreater{

	// TODO: refactoring required
	public static void createStackTraceToolTip(final Tree tree) {
		tree.setToolTipText("");
		final Listener labelListener = new Listener () {
			public void handleEvent (Event event) {
				Label label = (Label)event.widget;
				Shell shell = label.getShell ();
				switch (event.type) {
					case SWT.MouseDown:
						Event e = new Event ();
						e.item = (TreeItem) label.getData ("_TABLEITEM");
						// Assuming table is single select, set the selection as if
						// the mouse down event went through to the table
						tree.setSelection (new TreeItem [] {(TreeItem) e.item});
						tree.notifyListeners (SWT.Selection, e);
						shell.dispose ();
						tree.setFocus();
						break;

					case SWT.MouseExit:
						shell.dispose ();
						break;
				}
			}
		};

		Listener treeListener = new Listener () {
			Shell tip = null;
			Label label = null;

			public void handleEvent (Event event) {
				switch (event.type) {
					case SWT.Dispose:
					case SWT.KeyDown:
					case SWT.MouseMove: {
						if (tip == null) break;
						tip.dispose ();
						tip = null;
						label = null;
						break;
					}
					case SWT.MouseHover: {
						Point coords = new Point(event.x, event.y);
						TreeItem item = tree.getItem(coords);
						if (item != null) {
							int columns = tree.getColumnCount();
							Rectangle rect = item.getBounds (0);
							if (rect.contains(coords)) {
								if (tip != null  && !tip.isDisposed ()) tip.dispose ();
								tip = new Shell (tree.getShell(), SWT.ON_TOP | SWT.NO_FOCUS | SWT.TOOL);
								tip.setBackground (tree.getDisplay().getSystemColor (SWT.COLOR_INFO_BACKGROUND));
								FillLayout layout = new FillLayout ();
								layout.marginWidth = 2;
								tip.setLayout (layout);
								label = new Label (tip, SWT.NONE);
								label.setForeground (tree.getDisplay().getSystemColor (SWT.COLOR_INFO_FOREGROUND));
								label.setBackground (tree.getDisplay().getSystemColor (SWT.COLOR_INFO_BACKGROUND));
								label.setData ("_TABLEITEM", item);
								label.setText (((MonitorCallDetails)item.getData()).getStackText());
								label.addListener (SWT.MouseExit, labelListener);
								label.addListener (SWT.MouseDown, labelListener);
								Point size = tip.computeSize (SWT.DEFAULT, SWT.DEFAULT);
								Point pt = tree.toDisplay (rect.x, rect.y);
								tip.setBounds (pt.x, pt.y, size.x, size.y);
								tip.setVisible (true);
								break;
							}
						}
					}
				}
			}
		}; 

		tree.addListener (SWT.Dispose, treeListener);
		tree.addListener (SWT.KeyDown, treeListener);
		tree.addListener (SWT.MouseMove, treeListener);
		tree.addListener (SWT.MouseHover, treeListener);
	}
	
}
