/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Vitaly A. Provodin, Intel - Initial API and implementation
 *
 * $Id: ThreadsTipHandler.java,v 1.5 2007/06/06 19:16:16 gnagarajan Exp $
 *****************************************************************************/
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

public class ThreadsTipHandler {

    private Shell tipShell;
    private Table tipTable;
    private Item tipItem;
    private Point tipPosition;

    public ThreadsTipHandler(Shell parent) {
	final Display display = parent.getDisplay();

	tipShell = new Shell(parent, SWT.ON_TOP | SWT.TOOL);
	GridLayout gridLayout = new GridLayout();
	gridLayout.numColumns = 2;
	gridLayout.marginWidth = 2;
	gridLayout.marginHeight = 2;
	tipShell.setLayout(gridLayout);
	GridData data = new GridData(GridData.BEGINNING,GridData.BEGINNING,true,true);
	tipShell.setLayoutData(data);
	tipShell.setBackground(display
		.getSystemColor(SWT.COLOR_INFO_BACKGROUND));

	tipTable = new Table(tipShell, SWT.NONE);
	tipTable.setForeground(display
		.getSystemColor(SWT.COLOR_INFO_FOREGROUND));
	tipTable.setBackground(display
		.getSystemColor(SWT.COLOR_INFO_BACKGROUND));
	tipTable.setHeaderVisible(false);
	tipTable.setLinesVisible(false);

//	tipTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
//		| GridData.VERTICAL_ALIGN_CENTER));
    }

    public void activateHoverHelp(final Control control) {
	control.addMouseListener(new MouseAdapter() {
	    public void mouseDown(MouseEvent e) {
		if (tipShell.isVisible())
		    tipShell.setVisible(false);
	    }
	});

	control.addMouseTrackListener(new MouseTrackAdapter() {
	    public void mouseExit(MouseEvent e) {
		if (tipShell.isVisible())
		    tipShell.setVisible(false);
		tipItem = null;

	    }

	    private void addItem(String name, String value) {
		TableItem line = new TableItem(tipTable, SWT.NONE);
		line.setText(0, name);
		line.setText(1, value);
	    }

	    private void fillValues(Point pt,
		    ThreadStatesCtrl threadStates, Item item) {
		if (item instanceof ThreadItem) {
		    TRCThread thrd = ((ThreadItem) item)._thread;
		    TRCThreadEvent threadEvent = Utils.findEvent(
			    thrd, threadStates.hitTimeTest(pt.x, pt.y), 0);
		    TRCThreadEvent nextEvent = Utils.findEvent(thrd,
			    threadStates.hitTimeTest(pt.x, pt.y), 1);
		    // thread name
		    addItem(UIMessages._THREAD_NAME, thrd.getName());
		    // class name
		    addItem(UIMessages._THREAD_CLASS_NAME, Utils.getThreadClassName(thrd));
		    // thread state
		    addItem(UIMessages._THREAD_STATE, Utils.getEventName(threadEvent));

		    TRCObject obj;
		    if (threadEvent instanceof TRCThreadWaitingForObjectEvent) {
			TRCThreadWaitingForObjectEvent event = (TRCThreadWaitingForObjectEvent) threadEvent;
			obj = event.getObjectWaitingFor();
			addItem(UIMessages._OBJECT_WAITING_FOR,
				obj != null ? obj.getIsA().getName() : "null");
			addItem(UIMessages._TIMEOUT, "" + event.getTimeout());

		    } else if (threadEvent instanceof TRCThreadWaitingForLockEvent) {
			TRCThreadWaitingForLockEvent event = (TRCThreadWaitingForLockEvent) threadEvent;
			obj = event.getLockedObject();
			String monitor = "null";
			if (obj != null) {
				TRCClass cls = obj.getIsA();
				if (cls != null) {
					monitor = "";
					if (cls.getPackage() != null && cls.getPackage().getName().length() > 0)
						monitor+= cls.getPackage().getName() + ".";
					monitor+= cls.getName();
				}
			}
			addItem(UIMessages._THREAD_MONITOR, monitor);
			TRCThread thread = event.getLockingThread();
			if (thread != null)
			    addItem(UIMessages._MONITOR_OWNER, thread.getName()
				    + "[" + Utils.getThreadClassName(thread) + "]");

		    }

		    // start time
		    double startTime = threadEvent == null ? thrd
			    .getStartTime() : threadEvent.getTime();
		    double stopTime = (nextEvent == null ? thrd.getStopTime()
			    : nextEvent.getTime());
		    double duration = stopTime - startTime;
		    addItem(UIMessages._THREAD_START_TIME, Utils.formatTime(startTime));
		    addItem(UIMessages._DURATION, duration > 0 ? Utils.formatTime(duration) : "?");

		} else if (item instanceof GroupItem) {
		    addItem(UIMessages._THREAD_GROUP_NAME, item.toString());
		    addItem(UIMessages._NUMBER_OF_THREADS, ""
			    + ((GroupItem) item)._threads.size());
		}
	    }

	    public void mouseHover(MouseEvent event) {
		Point pt = new Point(event.x, event.y);
		Widget widget = event.widget;
		Item item = null;
		if (widget instanceof ThreadStatesCtrl) {
		    ThreadStatesCtrl threadStates = (ThreadStatesCtrl) widget;
		    item = (Item) threadStates.getItem(pt);
		    tipTable.remove(0, tipTable.getItemCount() - 1);
		    new TableColumn(tipTable, SWT.NONE);
		    new TableColumn(tipTable, SWT.NONE);
		    fillValues(pt, threadStates, item);
		    tipTable.getColumn(0).setWidth(200);
		    tipTable.getColumn(1).pack();
		    tipTable.setSize(tipTable.computeSize(SWT.DEFAULT, 200));
		    tipShell.pack();
		} else if (widget == null) {
		    tipShell.setVisible(false);
		    tipItem = null;
		    return;
		}
		if (item == tipItem)
		    return;
		tipItem = item;
		tipPosition = control.toDisplay(pt);
		tipShell.pack();
		setHoverLocation(tipShell, tipPosition);
		tipShell.setVisible(true);
	    }
	});
    }

    private void setHoverLocation(Shell shell, Point position) {
	Rectangle displayBounds = shell.getDisplay().getBounds();
	Rectangle shellBounds = shell.getBounds();
	shellBounds.x = Math.max(Math.min(position.x, displayBounds.width
		- shellBounds.width), 0);
	shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height
		- shellBounds.height), 0);
	shell.setBounds(shellBounds);
    }

}