/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CustomAnalysisView.java,v 1.2 2010/12/08 14:55:16 mreid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.provisional.client.extension;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.jvmti.internal.client.TITracePlugin;

/**
* A utility class for the customAnalysisView extension point.
*
* Based on org.eclipse.tptp.platform.common.ui/src-common-internal/org/eclipse/hyades/ui/provisional/extension/CustomContentProvider.java
*/

public class CustomAnalysisView {
		
	/**
	 * The ID of the extension point.
	 */
	private final static String CUSTOM_ANALYSIS_VIEW_EXT_ID = TITracePlugin.PLUGIN_ID + ".customAnalysisView";

	private static ICustomAnalysisView[] providers = null;
	
	/**
	 * Provides access to the contributors for the customAnalysisView extension point.
	 * @return The registered plug-ins that use the extension point.
	 */
	public static ICustomAnalysisView[] getContributors() {
		
		if( null == providers ) {
			IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CUSTOM_ANALYSIS_VIEW_EXT_ID);
			List<ICustomAnalysisView> providerList = new ArrayList<ICustomAnalysisView>();
			try {
				if(elements != null) {
					for (int configElement = 0; configElement < elements.length; configElement++) {
						ICustomAnalysisView provider = (ICustomAnalysisView) elements[configElement].createExecutableExtension("class");
						if(provider != null)
							providerList.add(provider);
					}
				}
			} catch (CoreException e) {
				CommonPlugin.logError(e);
			}
			
			// Output the provider list to an array in order to return the result.
			providers = new ICustomAnalysisView[providerList.size()];
			for(int i = 0; i < providerList.size(); i++)
				providers[i] = (ICustomAnalysisView)providerList.get(i);
		}
		
		return providers;
	}

}
