/*****************************************************************************
 * Copyright (c) 2010 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * $Id: CustomColumn.java,v 1.2 2010/12/21 21:41:22 mreid Exp $ 
 *****************************************************************************/
package org.eclipse.tptp.trace.jvmti.provisional.client.extension;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.AttrLPAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.jvmti.internal.client.TITracePlugin;

public class CustomColumn {

	private int viewMode;
	private ColumnLabelAdapter labelAdapter;	
	private AttrLPAdapter attrAdapter;
	
	private String id;
	private int style;
	private String align;
	private int width;
	
	private ICustomColumnParticipation columnParticipation;
	
	public CustomColumn( 
			ICustomColumnParticipation columnParticipation,
			int viewMode,
			ColumnLabelAdapter labelAdapter, 
			AttrLPAdapter attrAdapter,
			String id, 
			int flags, 
			String align, 
			int width) {

		this.columnParticipation = columnParticipation;
		this.viewMode = viewMode;
		this.labelAdapter = labelAdapter;
		this.attrAdapter = attrAdapter;
		this.id = id;
		this.style = flags;
		this.align = align;
		this.width = width;
		
	}
	
	public int getViewMode() {
		return this.viewMode;
	}
	
	public ColumnLabelAdapter getLabelAdapter() {
		return this.labelAdapter;
	}
	
	public AttrLPAdapter getAttrAdapter() {
		return this.attrAdapter;
	}

	public String getId() {
		return this.id;
	}
	
	public int getStyle() {
		return this.style;
	}
	
	public String getAlign() {
		return this.align;
	}
	
	public int getWidth() {
		return this.width;
	}

	public boolean isEnabled( TraceViewerPage page ) {
		if( null != this.columnParticipation )
			return this.columnParticipation.isEnabled(page);
		else
			return true;
	}
	
	/**
	 * The ID of the extension point.
	 */
	private final static String CUSTOM_COLUMN_EXT_ID = TITracePlugin.PLUGIN_ID + ".customColumn";
	private static CustomColumn[] providers = null;
	
	public static CustomColumn[] getContributors() {
		
		if( null == providers ) {
			IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CUSTOM_COLUMN_EXT_ID);
			List<CustomColumn> providerList = new ArrayList<CustomColumn>();
			try {
				if(elements != null) {
					for (int configElement = 0; configElement < elements.length; configElement++) {
						
						IConfigurationElement el = elements[configElement];
						
						ICustomColumnParticipation columnParticipation = null;
						if( null != el.getAttribute("columnParticipation") ) 
							columnParticipation = (ICustomColumnParticipation)el.createExecutableExtension("columnParticipation");
						ColumnLabelAdapter labelAdapter = (ColumnLabelAdapter)el.createExecutableExtension("labelAdapter");
						AttrLPAdapter attrAdapter = (AttrLPAdapter)el.createExecutableExtension("attrAdapter");

						int viewMode = Integer.valueOf(el.getAttribute("viewMode"));
						String attrib = el.getAttribute("id");
						int style = Integer.valueOf(el.getAttribute("style"));
						String align = el.getAttribute("align");
						int width = Integer.valueOf(el.getAttribute("width"));
						
						CustomColumn column = new CustomColumn(columnParticipation, viewMode, labelAdapter, attrAdapter, attrib, style, align, width);
						providerList.add(column);
					}
				}
			} catch (CoreException e) {
				CommonPlugin.logError(e);
			}
			
			// Output the provider list to an array in order to return the result.
			providers = new CustomColumn[providerList.size()];
			for(int i = 0; i < providerList.size(); i++)
				providers[i] = (CustomColumn)providerList.get(i);
		}
		
		return providers;
	}

}
