/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ICustomAnalysisView.java,v 1.2 2010/12/08 14:55:16 mreid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.provisional.client.extension;

import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseProfilerView;

/**
 * An interface for the customAnalysisView extension point to customize the analysis views.
 */

public interface ICustomAnalysisView {
	
	/**
	 * Returns the children of the parent element to display in the view.
	 * @param parentElement The element to obtain the children for.
	 * @return The children of the parent element.
	 */
	public Object[] getChildren(Object parentElement);
	
	/**
	 * Determines if the tree view should restore the expanded items on a tree refresh.
	 * @return true if the tree should be expanded.
	 */
	public boolean getRestoreExpandedItems();
	
	/**
	 * @return true if hasChildren() should be used instead of getChildren for determining if 
	 * the element has children to be displayed.
	 */
	public boolean getEngineForHasChildren();
	
	/**
	 * 
	 * @param element the element to check for child elements.
	 * @return true if the element has children to display.
	 */
	public boolean hasChildren(Object element);
	
	/**
	 * Handles profile events and can be used to update the view based on the model or 
	 * request an update of the data cache based on the event sent.
	 *  
	 * @param event The profile event to be handled.
	 * @param view The view for which the event will be handled.
	 */
	public void handleProfileEvent(ProfileEvent event, BaseProfilerView view);
	
	/**
	 * Attach the custom analysis view to the given profiling view. This allows
	 * per-view setup to occur.
	 * 
	 * Note that more than one view may be attached to a single ICustomAnalysisVIew
	 * simultaneously.
	 * 
	 * @param view The view being attached
	 * @param page The trace UI page
	 */
	public void attachView(BaseProfilerView view, TraceViewerPage page);
	
	/**
	 * Detach the custom analysis view from the given profiling view. This allows
	 * per-view takedown to occur.
	 * 
	 * @param view
	 */
	public void detachView(BaseProfilerView view);

}
