/**********************************************************************
 Copyright (c) 2007, 2008 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: ConfigGenerator.java,
 
 Contributors:
     IBM - initial implementation
 **********************************************************************/

package org.eclipse.tptp.platform.iac.administrator;

import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.iac.administrator.internal.common.CommonConstants;
import org.eclipse.tptp.platform.iac.administrator.internal.preference.VMChangeListener;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 * 
 * @author Navid Mehregani
 */
public class AdminPlugin extends AbstractUIPlugin {

	/* The plug-in ID */
	public static final String PLUGIN_ID = "org.eclipse.tptp.platform.iac.administrator";

	/* The shared instance */
	private static AdminPlugin plugin;
	
	/* The preference store used for the main Agent Controller preference page */
	private IPreferenceStore _preferenceStore;
	
	/**
	 * The constructor
	 */
	public AdminPlugin() {
		super();	
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		_preferenceStore = getPreferenceStore();
		plugin = this;
		JavaRuntime.addVMInstallChangedListener(new VMChangeListener());
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		/* NM: Bugzilla 173330: Terminate the Agent Controller if it has been started */
		AutoStartStop.stopIAC();

		// JPT: Moved this after the stopIAC call to prevent NPE in error
		// handling code of AutoStartStop.stopIAC()
		plugin = null;
		
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static AdminPlugin getDefault() {
		return plugin;
	}
	
	/* The following methods are used to manipulate the preference store */
	
	public boolean getBoolean(String name) {
		return _preferenceStore.getBoolean(name);
	}

	public boolean getDefaultBoolean(String name) {
		return _preferenceStore.getDefaultBoolean(name);
	}

	public int getDefaultInt(String name) {
		return _preferenceStore.getDefaultInt(name);
	}

	public String getDefaultString(String name) {
		return _preferenceStore.getDefaultString(name);
	}

	public int getInt(String name) {
		return _preferenceStore.getInt(name);
	}

	public String getString(String name) {
		return _preferenceStore.getString(name);
	}
	
	public void setBoolean(String name, boolean value) {
		_preferenceStore.setValue(name, value);
		
	}

	public void setInt(String name, int value) {
		_preferenceStore.setValue(name, value);
	}

	public void setString(String name, String value) {
		String n = name;
		String v = value;

		if(n == null) {
			n = "";
		}
		if(v == null) {
			v = "";
		}
		_preferenceStore.setValue(n, v);
	}

	protected void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(CommonConstants.DATAPOOL_PORT_ENABLED, false);
		store.setDefault(CommonConstants.DATAPOOL_PORT_NUMBER, "");
		store.setDefault(CommonConstants.DATAPOOL_PORT_RANDOM, true);
	}

}
