/**********************************************************************
 Copyright (c) 2007, 2010 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: ConfigGenerator.java,
 
 Contributors:
     IBM - initial implementation
 **********************************************************************/
package org.eclipse.tptp.platform.iac.administrator.internal.common;

/**
 * Common constants used for this plugin
 * @author Navid Mehregani
 *
 */
public class CommonConstants {

	/* XML parsing constants */    
    public static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";  /** Namespaces feature id (http://xml.org/sax/features/namespaces). */
    public static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";     /** Validation feature id (http://xml.org/sax/features/validation). */
    public static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";     /** Schema validation feature id (http://apache.org/xml/features/validation/schema). */
    public static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";    /** Schema full checking feature id (http://apache.org/xml/features/validation/schema-full-checking). */
    public static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";    /** Validate schema annotations feature id (http://apache.org/xml/features/validate-annotations). */
    public static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";   /** Generate synthetic schema annotations feature id (http://apache.org/xml/features/generate-synthetic-annotations). */
    public static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";   /** Dynamic validation feature id (http://apache.org/xml/features/validation/dynamic). */
    public static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";    /** Load external DTD feature id (http://apache.org/xml/features/nonvalidating/load-external-dtd). */
    public static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";    /** XInclude feature id (http://apache.org/xml/features/xinclude). */
    public static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";    /** XInclude fixup base URIs feature id (http://apache.org/xml/features/xinclude/fixup-base-uris). */
    public static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";   /** XInclude fixup language feature id (http://apache.org/xml/features/xinclude/fixup-language). */
 
    
    /* The file separator for this platform */
	public static final String FILE_SEPARATOR = System.getProperty("file.separator"); 
	
	/* Line separator for this platform */
	public static final String LINE_SEPARATOR = System.getProperty("line.separator"); 
	
	/* File extension of an executable */
	public static final String EXECUTABLE_EXTENSION = ((System.getProperty("os.name").toLowerCase().indexOf("windows") != -1)?".exe":"");

	/* BUG 308169: Use javaw on Windows */
	public static final String JAVA_EXECUTABLE_NAME = ((System.getProperty("os.name").toLowerCase().indexOf("windows") != -1)?"javaw":"java");
	
	 /* The platform we're running on */
	public static final String PLATFORM = System.getProperty("os.name").toLowerCase(); 

	/* Constants for the preference lists */
	public static final String HOST_LIST = "hostList";
	public static final String USER_LIST = "userList";
	
	/* Operating System */
	public static final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
	
	/* Operating System Architecture */
	public static final String SYSTEM_ARCH = System.getProperty("os.arch").toLowerCase();
	
	/* IAC plugin ID, excluding the OS and system architecture appended to it */
	public static final String IAC_PLUGIN_ID = "org.eclipse.tptp.platform.ac";
	
	/* JVMTI plugin ID, which contains all the JVMTI native files */
	public static final String JVMTI_PLUGIN_ID = "org.eclipse.tptp.platform.jvmti.runtime";
	
	/* Probekit plugin ID, which contains all the probekit native files */
	public static final String PROBEKIT_PLUGIN_ID = "org.eclipse.hyades.probekit";
	
	/* These constants should be used wherever the code becomes dependent on os and system architecture */
	public static final String WIN_IA32 = "win_ia32";
	public static final String WIN_EM64T = "win_em64t";
	public static final String WIN_IPF = "win_ipf";
	public static final String LINUX_IA32 = "linux_ia32";
	public static final String LINUX_EM64T = "linux_em64t";
	public static final String LINUX_IPF = "linux_ipf";
	
	/* Execution framework Plugin */
	public static final String EXECUTION_FRAMEWORK = "org.eclipse.hyades.execution";
	
	/* Workbench firewall settings */
	public static final String DATAPOOL_PORT_ENABLED = "datapool_port_enabled";
	public static final String DATAPOOL_PORT_NUMBER = "datapool_port_number";
	public static final String DATAPOOL_PORT_RANDOM = "datapool_port_random";
}
