/***********************************************************************
 Copyright (c) 2007, 2008 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: ConfigGenerator.java,
 
 Contributors:
     IBM - initial implementation
 **********************************************************************/

package org.eclipse.tptp.platform.iac.administrator.internal.common;

import java.io.File;
import java.io.FileFilter;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.agentcontroller.config.FileFilterImpl;
import org.eclipse.tptp.platform.agentcontroller.config.IConfigUtility;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;

public class IACConfigUtil implements IConfigUtility {
	

	public String resolveAbsolutePath(String directory, String pluginAlias) {
		
		String result;
		
		try{
						
			org.osgi.framework.Bundle bundle = org.eclipse.core.runtime.Platform.getBundle(pluginAlias);		
			File f = FileLocator.getBundleFile(bundle);
			 
			if (f == null){
				return "null";
			}		
			
			if(f.exists() && !f.isDirectory()){
				//228856 
				if("org.eclipse.swt".equalsIgnoreCase(pluginAlias)){
					return AddAllSWTJars(f);
				}else
					//return the path of jar file
					return f.getAbsolutePath();		
			}else if (f.isDirectory()){
				return locateBundleJarFile(f.getCanonicalPath());
			}else if(!f.exists()){
				return "null";
			}
		}catch(Exception e){}
		return "null";
	}
	
	/**
	 * 
	 * @param bundleLocation  Location of Eclipse plugin bundle
	 *
	 * @return  path contains all .jar and .zip under bundleLocation directory.
	 */
	private String locateBundleJarFile(String bundleLocation){
		
		StringBuffer classpathBuffer = new StringBuffer();
		
		FileFilter filter = new FileFilter() {
	        public boolean accept(File file) {
	        	return (file.getName().endsWith(".zip") ||file.getName().endsWith(".jar"));		
	        }
	    };
	    
	    File pluginDir = new File(bundleLocation);
	    	
	    File[] jars = pluginDir.listFiles(filter);
	    for(int i = 0; i < jars.length; i++){	    	
	    	classpathBuffer.append(jars[i].getAbsolutePath() + File.pathSeparator);
	    }
	    
	    String classpath = classpathBuffer.toString();
		if(classpath.length() > 1) {
			return classpath.substring(0, classpath.length() - 1); // removing the last file.pathSeparator
		}else {
			return new String("null");
		}		   
	}
	
	private String AddAllSWTJars(File swtJar){
		
		// <Eclipse>/plugin contains three swt jar:  org.eclipse.swt_<version>.jar, org.eclipse.swt.<platform>_<version>.jar 
		// and org.eclipse.swt.<platform>.source_<version>.jar.   FileLocator returns the path to the first one. 
		// We need the path of the 2nd jar.  
		
		StringBuffer path = new StringBuffer();
		if(swtJar == null)
			return "null";
		
		File dir = swtJar.getParentFile();
		File[] jars = dir.listFiles(new FileFilterImpl("^org.eclipse.swt.*"));

		for(int i = 0; i < jars.length; i++) {
			path.append(jars[i].getAbsolutePath() + File.pathSeparator);
		}
		String classpath = path.toString();
		if(classpath.length() > 1) {
			return classpath.substring(0, classpath.length() - 1); // removing the last file.pathSeparator
		}else {
			return new String("null");
		}	
		
	}
	
	
	/**
	 * This method should only be called when IAC is invoked by workbench
	 */
	public File getACConfigDirectory(String home,boolean isInvokedByWorkbench, boolean isIacConfig){
		
		IPath path = Platform.getStateLocation(AdminPlugin.getDefault().getBundle());
		
		File dir = new File(path.toString() + File.separator  + "config");
		dir.mkdirs();		
		return dir;

	}
	
	
	//this method should only be invoked by IAC
	public File getPluginPropertyDirectory(boolean isInvokedByWorkbench){
		
		String result = "";
		
		if(isInvokedByWorkbench){
			IWorkspace workspace = ResourcesPlugin.getWorkspace();
			IWorkspaceRoot root = workspace.getRoot();
			IPath location = root.getLocation();
			result = location.toString() + File.separator + ".metadata" + File.separator + ".plugins";
		}
		
		return new File(result);

	}
	
}
