/**********************************************************************
 Copyright (c) 2007 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: ConfigGenerator.java,
 
 Contributors:
     IBM - initial implementation
 **********************************************************************/

package org.eclipse.tptp.platform.iac.administrator.internal.common;

import org.w3c.dom.Document;
import org.w3c.dom.Text;

import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/**
 * DOM parser wrapper
 *
 */
public interface ParserWrapper {

    /** Parses the specified URI and returns the document. */
    public Document parse(String uri) throws Exception;

    /**
     * Set the state of a feature.
     */
    public void setFeature(String featureId, boolean state)
        throws  SAXNotRecognizedException, SAXNotSupportedException; 

    /** Returns the document information. */
    public XmlFile getDocumentInfo();

    public interface XmlFile {
    
        public boolean isIgnorableWhitespace(Text text);

    } 
}
