/**********************************************************************
 Copyright (c) 2007, 2008 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: ConfigGenerator.java,v 1.7 2008/11/25 20:58:18 jkubasta Exp $
  
 Contributors:
     IBM - initial implementation
 **********************************************************************/


package org.eclipse.tptp.platform.iac.administrator.internal.config;

import java.io.File;

import org.eclipse.tptp.platform.agentcontroller.config.Constants;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfig;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.common.IACConfigUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.preference.PreferenceMessages;


/**
 * This class was introduced as part of enhancement 173330.  It's used for 
 * automatic generation of IAC's configuration file
 * 
 * @author Navid Mehregani
 */
public class ConfigGenerator {	
	
	public ConfigGenerator() {
		SetConfig.setIsIACConfiguration(true);
		SetConfig.setIsInvokedByWorkbench(true);
	}
	
	/**
	 * Allow=ALL 
	 * Security=false
	 */
	public void allowAllWithNoSecurity(String acHome, String javaExecutable, String pluginsFolder, File[] plugins)
	{
		String[] arguments = {Constants.SILENT_FLAG, Constants.RASERVER_HOME + "=\"" + acHome + "\"", Constants.PLUGINS_HOME + "=\"" + pluginsFolder + "\"", 
				Constants.JAVA_PATH + "=\"" + javaExecutable + "\"", Constants.ALLOW_HOST_TYPE+ "=" + Constants.ALLOW_ALL, Constants.SECURITY + "=" + Constants.SECURITY_OFF, 
				Constants.HOSTS + "=\"\"", Constants.USERS + "=\"\""};
		SetConfig.generateConfig(arguments, new IACConfigUtil(), plugins);
	}
	
	/**
	 * Allow=LOCAL
	 * Security=false
	 */
	public void setUpLocallyWithNoSecurity(String acHome, String javaExecutable, String pluginsFolder, File[] plugins)
	{
		String[] arguments = {Constants.SILENT_FLAG, Constants.RASERVER_HOME + "=\"" + acHome + "\"", Constants.JAVA_PATH + "=\"" + javaExecutable + "\"", 
				Constants.PLUGINS_HOME + "=\"" + pluginsFolder + "\"", Constants.ALLOW_HOST_TYPE + "=" + Constants.ALLOW_LOCAL, Constants.SECURITY + "=" + Constants.SECURITY_OFF, 
				Constants.HOSTS + "=\"\"", Constants.USERS + "=\"\""};
		SetConfig.generateConfig(arguments, new IACConfigUtil(), plugins);
	}
	
	/**
	 * Allow=CUSTOM
	 * Hosts='hosts' variable given.  In case 'hosts' is null or empty, default value of
	 * localhost will be used
	 */
	public void customAccessWithNoSecurity(String hosts, String acHome, String javaExecutable, String pluginsFolder, File[] plugins)
	{
		if (!AdminUtil.validString(hosts))
			hosts = "localhost";
		
		String[] arguments = {Constants.SILENT_FLAG, Constants.RASERVER_HOME + "=\"" + acHome + "\"", Constants.JAVA_PATH + "=\"" + javaExecutable + "\"", Constants.PLUGINS_HOME + "=\"" + pluginsFolder + "\"", 
				Constants.ALLOW_HOST_TYPE + "=" + Constants.ALLOW_CUSTOM, Constants.HOSTS + "=" + hosts, Constants.SECURITY + "=" + Constants.SECURITY_OFF, Constants.USERS + "=\"\""};
		SetConfig.generateConfig(arguments, new IACConfigUtil(), plugins);
	}
	
	/**
	 * Allow=ALL
	 * Security=true
	 * Users='users' variable given. In case 'users' is null or empty, default value of 
	 * ANY will be used
	 */
	public void allowAllWithSecurity(String userType, String userList, String acHome, String javaExecutable, String pluginsFolder, File[] plugins)
	{
		if (!AdminUtil.validString(userType))
			userType = Constants.USER_ALL;
		
		String[] arguments = {Constants.SILENT_FLAG, Constants.RASERVER_HOME + "=\"" + acHome + "\"", Constants.JAVA_PATH + "=\"" + javaExecutable + "\"", Constants.PLUGINS_HOME + "=\"" + pluginsFolder + "\"",
				Constants.ALLOW_HOST_TYPE + "=" + Constants.ALLOW_ALL, Constants.SECURITY + "=" + Constants.SECURITY_ON, Constants.USERTYPE + "=" + userType,Constants.USERLIST + "=" + userList, Constants.HOSTS + "=\"\""};
		SetConfig.generateConfig(arguments, new IACConfigUtil(), plugins);
	}
	
	/**
	 * Allow=LOCAL
	 * Security=true
	 * Users='users' variable given. In case 'users' is null or empty, default value of
	 * ANY will be used
	 */
	public void setUpLocallyWithSecurity(String userType, String userList, String acHome, String javaExecutable, String pluginsFolder, File[] plugins)
	{
		if (!AdminUtil.validString(userType))
			userType = Constants.USER_ALL;
		
		String[] arguments = {Constants.SILENT_FLAG, Constants.RASERVER_HOME + "=\"" + acHome + "\"", Constants.JAVA_PATH + "=\"" + javaExecutable + "\"", 
				Constants.PLUGINS_HOME + "=\"" + pluginsFolder + "\"", Constants.SECURITY + "=" + Constants.SECURITY_ON, Constants.USERTYPE + "=" + userType,Constants.USERLIST + "=" + userList,
				Constants.ALLOW_HOST_TYPE+ "=" + Constants.ALLOW_LOCAL, Constants.HOSTS + "=\"\""};
		SetConfig.generateConfig(arguments, new IACConfigUtil(), plugins);
	}

	/**
	 * Allow=CUSTOM
	 * Hosts='hosts' variable given.  In case 'hosts' is null or empty, default value of
	 * localhost will be used
	 * Security=true
	 * Users='users' variable given. In case 'users' is null or empty, default value of
	 * ANY will be used
	 */
	public void customAccessWithSecurity(String hosts, String userType,  String userList, String acHome, String javaExecutable, String pluginsFolder, File[] plugins)
	{
		if (!AdminUtil.validString(userType))
			userType = Constants.USER_ALL;
		
		if (!AdminUtil.validString(hosts))
			hosts = "localhost";
		
		String[] arguments = {Constants.SILENT_FLAG, Constants.RASERVER_HOME + "=\"" + acHome + "\"", Constants.JAVA_PATH + "=\"" + javaExecutable + "\"", Constants.ALLOW_HOST_TYPE + "=" + 
				Constants.ALLOW_CUSTOM, Constants.PLUGINS_HOME + "=\"" + pluginsFolder + "\"", Constants.HOSTS + "=" + hosts, Constants.SECURITY + "=" + Constants.SECURITY_ON, Constants.USERTYPE + "=" + userType,Constants.USERLIST + "=" + userList,};
		SetConfig.generateConfig(arguments,new IACConfigUtil(),  plugins);
	}
	
	/**
	 * Generate the configuration file based on the given values
	 * 
	 * @param hosts  Comma separated list of hosts that are allowed access to IAC
	 * @param users  Comma separated list of users that are allowed access to IAC 
	 * @param acHome  Absolute folder of IAC
	 * @param javaExecutable  Absolute folder of the Java executable that should be used by IAC
	 * @param pluginsFolder  Absolute folder for IAC's plugins folder
	 * @param plugins  IAC's plugins
	 */
	public void generateConfiguration(String acHome, String javaExecutable, String pluginsFolder, File[] plugins, boolean security, String userType, String userList,  String allowedHosts, String hosts)
	{
		/* Security ON */
		if(security)
		{
			if (userType.equals(PreferenceMessages.ANY_USER))
				userType = Constants.USER_ALL;
						
			/* All hosts */
			if (allowedHosts.equals(PreferenceMessages.ALL_HOSTS))
			{
				allowAllWithSecurity(userType, userList, acHome, javaExecutable, pluginsFolder, plugins);
			}
			/* Localhost */
			else if (allowedHosts.equals(PreferenceMessages.LOCALHOST))
			{
				setUpLocallyWithSecurity(userType, userList, acHome, javaExecutable, pluginsFolder, plugins);
			}
			/* Custom set of hosts */
			else
			{
				customAccessWithSecurity(hosts, userType, userList, acHome, javaExecutable, pluginsFolder, plugins);
			}
		}
		/* Security OFF  */
		else
		{
			/* All hosts */
			if (allowedHosts.equals(PreferenceMessages.ALL_HOSTS))
			{
				allowAllWithNoSecurity(acHome, javaExecutable, pluginsFolder, plugins);
			}
			/* Localhost */
			else if (allowedHosts.equals(PreferenceMessages.LOCALHOST))
			{
				setUpLocallyWithNoSecurity(acHome, javaExecutable, pluginsFolder, plugins);
			}
			/* Custom set of hosts */
			else
			{
				customAccessWithNoSecurity(hosts, acHome, javaExecutable, pluginsFolder, plugins);
			}
		}
	}
}
