/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IACPreferencePageInitializer.java,v 1.1 2007/04/12 18:02:53 nmehrega Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.iac.administrator.internal.preference;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;
import org.osgi.service.prefs.Preferences;

/**
 * This class is used initialize the values on Agent Controller's preference page
 * 
 * @author Navid Mehregani
 *
 */
public class IACPreferencePageInitializer extends	AbstractPreferenceInitializer {

	/**
	 * Set up the default values for the Agent Controller preference page
	 */
	public void initializeDefaultPreferences() {
		Preferences node = new DefaultScope().getNode(AdminPlugin.PLUGIN_ID);
		node.putBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL, true);
		node.put(PreferenceMessages.JAVA_EXECUTABLE, AdminUtil.getJVMExecutable());
		node.put(PreferenceMessages.ALLOWED_HOSTS, PreferenceMessages.LOCALHOST);		
		node.putBoolean(PreferenceMessages.AC_SECURITY, false);
		node.put(PreferenceMessages.ALLOWED_USERS, PreferenceMessages.ANY_USER);
	}

}
