/*******************************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.iac.administrator.internal.preference;

import org.eclipse.osgi.util.NLS;

/**
 * Created as a result of bugzilla 173330.  Contains translatable messages in the preference page
 * @author Navid Mehregani
 *
 */
public class PreferenceMessages extends NLS {

	private static final String BUNDLE_NAME = "org.eclipse.tptp.platform.iac.administrator.internal.preference.messages";//$NON-NLS-1$

	public PreferenceMessages() {
		// Do not instantiate
	}

	public static String ENABLE_DISABLE_LABEL;
	public static String ENABLE_IAC;
	public static String DISABLE_IAC;
	public static String JAVA_EXECUTABLE;
	public static String MODIFY_LINK;
	public static String ALLOWED_HOSTS;
	public static String ALL_HOSTS;
	public static String LOCALHOST;
	public static String CUSTOM_HOSTS;
	public static String HOST_LIST_LABEL;
	public static String AC_SECURITY;	
	public static String SECURITY_OFF;
	public static String SECURITY_ON;
	public static String ALLOWED_USERS;
	public static String ANY_USER;
	public static String CUSTOM_USER;
	public static String USER_LIST_LABEL;
	public static String ADD_BUTTON;
	public static String EDIT_BUTTON;
	public static String REMOVE_BUTTON;
	public static String ADD_BUTTON2;
	public static String EDIT_BUTTON2;
	public static String REMOVE_BUTTON2;
	public static String NOT_SUPPORT_PLATFORM;
	public static String ACCESS_TO_IAC_CONFIG_DENIED_WITH_VALID_CONFIG;
	public static String ACCESS_TO_IAC_CONFIG_DENIED_WITH_INVALID_CONFIG;
	
	public static String ERROR_DIALOG_TITLE;
	public static String ERROR_GENERAL;
	
	/* Confirmation dialog */
	public static String CONFIRMATION_TITLE;
	public static String CONFIRMATION_MESSAGE;
	public static String CONFIRMATION_STOP_MESSAGE;
	
	/* User/host dialog */
	public static String ADD_USER;
	public static String USER_NAME;
	public static String ADD_HOST;
	public static String EDIT_HOST;
	public static String HOST_NAME;
	public static String ITEM_ALREADY_IS_IN_LIST;

	
	static {
		NLS.initializeMessages(BUNDLE_NAME, PreferenceMessages.class);
	}
}