/**********************************************************************
 Copyright (c) 2007, 2008 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: ConfigGenerator.java,
 
 Contributors:
     IBM - initial implementation
 **********************************************************************/

package org.eclipse.tptp.platform.iac.administrator.internal.preference;

import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;

/**
 * Listener class responsible for detecting when the workbench VM changes.
 * 
 * @author Navid Mehregani
 *
 */
public class VMChangeListener implements IVMInstallChangedListener {
	
	public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
		AdminPlugin adminPlugin = AdminPlugin.getDefault();
		String jvmExecutable = AdminUtil.getJVMExecutable(current.getInstallLocation().toString());
		
		/* Update the Java executable */
		adminPlugin.setString(PreferenceMessages.JAVA_EXECUTABLE, jvmExecutable);

		boolean iacEnabled = adminPlugin.getBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL);		
		
		/* Is IAC enabled? */
		if (iacEnabled)
		{
			/* Indicates whether it's necessary to restart IAC */
			boolean restartIAC = false;
			
			if (AutoStartStop.getIACStarted())
			{	
				/* Confirm whether the user wants to restart IAC */
				final Display currentDisplay = adminPlugin.getWorkbench().getDisplay();
				class RestartConfirmation implements Runnable
				{
					private int response;

					public void run() 
					{
						MessageDialog md = AdminUtil.getConfirmationDialog(currentDisplay.getActiveShell(), PreferenceMessages.CONFIRMATION_TITLE, PreferenceMessages.CONFIRMATION_MESSAGE);
						response = md.open();
					}
					
					public int getResponse()
					{
						return response;
					}
					
				}
				RestartConfirmation responseConfirmation = new RestartConfirmation();
				currentDisplay.syncExec(responseConfirmation);
				
				restartIAC = (responseConfirmation.getResponse() == 0);
			}
			
			/* Stop IAC before modifying its configuration file */
			if (restartIAC)
				AutoStartStop.stopIAC();
			
			/* Generate IAC's configuration file */
			AdminUtil.generateConfigFile(true);
		
			/* IAC will automatically start next time we attempt to connect to it */
		}
	}

	public void vmAdded(IVMInstall vm) {
		/* Ignore */

	}

	public void vmChanged(PropertyChangeEvent event) {
		/* Ignore */

	}

	public void vmRemoved(IVMInstall vm) {
		/* Ignore */
	}
	
}
