/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.edit.provider.ComposedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlaidImage
extends ComposedImage {
    public static final int BASIC = 0;
    public static final int OVERLAY_TOP_LEFT = 1;
    public static final int OVERLAY_TOP_RIGHT = 2;
    public static final int OVERLAY_BOTTOM_LEFT = 3;
    public static final int OVERLAY_BOTTOM_RIGHT = 4;
    public static final int OVERLAY_CENTER = 5;
    private int[] positions;

    public OverlaidImage(Object[] images, int[] positions) {
        super(Arrays.asList(images));
        this.positions = positions;
    }

    public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
        ArrayList<ComposedImage.Point> results = new ArrayList<ComposedImage.Point>();
        int i = 0;
        for (ComposedImage.Size imageSize : this.imageSizes) {
            ComposedImage.Point point = new ComposedImage.Point();
            if (i < this.positions.length) {
                switch (this.positions[i]) {
                    case 2: {
                        point.x = size.width - imageSize.width;
                        point.y = 0;
                        break;
                    }
                    case 3: {
                        point.x = 0;
                        point.y = size.height - imageSize.height;
                        break;
                    }
                    case 4: {
                        point.x = size.width - imageSize.width;
                        point.y = size.height - imageSize.height;
                        break;
                    }
                    case 5: {
                        point.x = (size.width - imageSize.width) / 2;
                        point.y = (size.height - imageSize.height) / 2;
                        break;
                    }
                    default: {
                        point.x = 0;
                        point.y = 0;
                    }
                }
            }
            results.add(point);
            ++i;
        }
        return results;
    }
}

