/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Architecture implements Enumerator
{
    X86(0, "X86", "x86"),
    PPC(1, "PPC", "ppc"),
    X86_64(2, "X86_64", "x86_64"),
    IA64(3, "IA64", "ia64"),
    IA64_32(4, "IA64_32", "ia64_32"),
    SPARC(5, "Sparc", "sparc");

    public static final int X86_VALUE = 0;
    public static final int PPC_VALUE = 1;
    public static final int X86_64_VALUE = 2;
    public static final int IA64_VALUE = 3;
    public static final int IA64_32_VALUE = 4;
    public static final int SPARC_VALUE = 5;
    private static final Architecture[] VALUES_ARRAY;
    public static final List<Architecture> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Architecture[]{X86, PPC, X86_64, IA64, IA64_32, SPARC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Architecture get(int value) {
        switch (value) {
            case 0: {
                return X86;
            }
            case 1: {
                return PPC;
            }
            case 2: {
                return X86_64;
            }
            case 3: {
                return IA64;
            }
            case 4: {
                return IA64_32;
            }
            case 5: {
                return SPARC;
            }
        }
        return null;
    }

    public static Architecture get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Architecture result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Architecture getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Architecture result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private Architecture(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

