/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public class MonitorUtils {
    public static void begin(IProgressMonitor monitor, int ticks) throws OperationCanceledException {
        MonitorUtils.begin(monitor, null, ticks);
    }

    public static void begin(IProgressMonitor monitor, String taskName, int ticks) throws OperationCanceledException {
        if (monitor != null) {
            MonitorUtils.checkedTestCancelStatus(monitor);
            monitor.beginTask(taskName, ticks);
        }
    }

    public static void complete(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null) {
            try {
                MonitorUtils.checkedTestCancelStatus(monitor);
                monitor.beginTask(null, 1);
            }
            finally {
                monitor.done();
            }
        }
    }

    public static void done(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null) {
            MonitorUtils.checkedTestCancelStatus(monitor);
            monitor.done();
        }
    }

    public static IProgressMonitor ensureNotNull(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        } else {
            MonitorUtils.checkedTestCancelStatus(monitor);
        }
        return monitor;
    }

    public static IProgressMonitor subMonitor(IProgressMonitor monitor, int ticks) throws OperationCanceledException {
        if (monitor != null) {
            MonitorUtils.checkedTestCancelStatus(monitor);
            monitor = new SubProgressMonitor(monitor, ticks, 0);
        }
        return monitor;
    }

    public static IProgressMonitor subMonitor(IProgressMonitor monitor, int ticks, boolean prependMainLabelToSubtask) throws OperationCanceledException {
        if (monitor != null) {
            MonitorUtils.checkedTestCancelStatus(monitor);
            int style = prependMainLabelToSubtask ? 4 : 0;
            monitor = new SubProgressMonitor(monitor, ticks, style);
        }
        return monitor;
    }

    public static void subTask(IProgressMonitor monitor, String name) throws OperationCanceledException {
        if (monitor != null) {
            MonitorUtils.checkedTestCancelStatus(monitor);
            monitor.subTask(name);
        }
    }

    public static void testCancelStatus(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void worked(IProgressMonitor monitor, int work) throws OperationCanceledException {
        if (monitor != null) {
            MonitorUtils.checkedTestCancelStatus(monitor);
            monitor.worked(work);
        }
    }

    private static void checkedTestCancelStatus(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

