/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.CustomCategory;
import org.eclipse.b3.aggregator.Feature;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.b3.aggregator.util.ItemUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIUsToCustomCategoryCommand
extends AbstractCommand
implements DragAndDropFeedback {
    private CustomCategory customCategory;
    private Map<IInstallableUnit, MappedRepository> mapFeatureMappedRepo = new HashMap<IInstallableUnit, MappedRepository>();
    private List<IInstallableUnit> selectedFeatures;
    private List<Feature> featuresAddedToCustomCategory = new ArrayList<Feature>();
    private Map<MappedRepository, List<MappedUnit>> unitsAddedToMappedRepo = new HashMap<MappedRepository, List<MappedUnit>>();

    public AddIUsToCustomCategoryCommand(CustomCategory category, List<IInstallableUnit> selectedFeatures) {
        super(String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Add_to_command_prefix")) + " " + (category.getLabel() == null || category.getLabel().length() == 0 ? String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Category_type")) + " ''" : String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Category_type")) + " " + category.getLabel()));
        this.selectedFeatures = selectedFeatures;
        this.customCategory = category;
    }

    public void execute() {
        this.featuresAddedToCustomCategory.clear();
        this.unitsAddedToMappedRepo.clear();
        for (IInstallableUnit feature : this.selectedFeatures) {
            MappedRepository repo = this.mapFeatureMappedRepo.get(feature);
            if (!repo.isEnabled()) continue;
            MappedUnit unit = ItemUtils.findMappedUnit(repo, feature);
            if (unit == null) {
                unit = AggregatorFactory.eINSTANCE.createMappedUnit(feature);
                repo.addUnit(unit);
                List<MappedUnit> units = this.unitsAddedToMappedRepo.get(repo);
                if (units == null) {
                    units = new ArrayList<MappedUnit>();
                    this.unitsAddedToMappedRepo.put(repo, units);
                }
                units.add(unit);
            } else if (!unit.isEnabled()) continue;
            if (!(unit instanceof Feature)) continue;
            this.customCategory.getFeatures().add((Object)((Feature)unit));
            this.featuresAddedToCustomCategory.add((Feature)unit);
        }
    }

    public int getFeedback() {
        return 1;
    }

    public int getOperation() {
        return 4;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.customCategory.getFeatures().removeAll(this.featuresAddedToCustomCategory);
        for (MappedRepository mappedRepo : this.unitsAddedToMappedRepo.keySet()) {
            for (MappedUnit unit : this.unitsAddedToMappedRepo.get(mappedRepo)) {
                mappedRepo.removeUnit(unit);
            }
        }
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return true;
    }

    protected boolean prepare() {
        Aggregator aggregator = (Aggregator)((EObject)this.customCategory).eContainer();
        for (IInstallableUnit feature : this.selectedFeatures) {
            if (!(((EObject)feature).eContainer() instanceof MetadataRepository)) {
                return false;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)feature).eContainer();
            MappedRepository mappedRepo = ItemUtils.findMappedRepository(aggregator, mdr);
            if (mappedRepo == null) continue;
            this.mapFeatureMappedRepo.put(feature, mappedRepo);
            if (ItemUtils.findMapRule(mappedRepo, feature) == null) continue;
            return false;
        }
        return this.customCategory != null && this.selectedFeatures != null && this.selectedFeatures.size() > 0 && this.isEnabled();
    }

    private boolean isEnabled() {
        for (IInstallableUnit feature : this.mapFeatureMappedRepo.keySet()) {
            MappedRepository repo = this.mapFeatureMappedRepo.get(feature);
            if (repo == null) {
                return false;
            }
            MappedUnit unit = ItemUtils.findMappedUnit(repo, feature);
            if ((unit == null || unit.isEnabled()) && (unit != null || repo == null || repo.isEnabled())) continue;
            return false;
        }
        return true;
    }
}

