/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.b3.cli.AbstractCommand;
import org.eclipse.b3.cli.HeadlessActivator;
import org.eclipse.b3.cli.helpers.CliException;
import org.eclipse.b3.cli.helpers.EmptyCommand;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.IOUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headless
implements IApplication {
    private static final int CONSOLE_WIDTH = 80;
    private static final String APPLICATION_NAME = "b3";
    private static final String COMMAND_EXTENSION = "org.eclipse.b3.cli.commands";
    private static final String COMMAND_NAME_ATTR = "name";
    private static final String COMMAND_CLASS_ATTR = "class";

    /*
     * Unable to fully structure code
     */
    public static int run(String[] args, boolean verbose) throws Exception {
        block22: {
            block23: {
                try {
                    if (args.length == 0 || !args[0].matches("^(?i:[a-z_])+$")) {
                        throw new CliException("No command was specified");
                    }
                    command = Headless.getCommand(args[0]);
                    if (command == null) {
                        throw new CliException("No such command: " + args[0]);
                    }
                    commandParser = new CmdLineParser((Object)command);
                    problem = null;
                    commandArgs = new String[args.length - 1];
                    System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);
                    try {
                        commandParser.parseArgument(commandArgs);
                    }
                    catch (CmdLineException e) {
                        problem = e.getMessage();
                    }
                    output = null;
                    if (command.isHelp()) {
                        output = System.out;
                    } else if (problem != null) {
                        output = System.err;
                    }
                    if (output != null) {
                        if (problem != null && !command.isHelp()) {
                            output.println(String.valueOf(command.getName()) + ": " + problem);
                            output.println();
                        }
                        output.println("Usage: b3 " + command.getUsageTitle());
                        commandParser.setUsageWidth(80);
                        commandParser.printUsage((OutputStream)output);
                        if (command.isHelp() && (helpStream = command.getHelpStream()) != null) {
                            try {
                                output.println();
                                output.println("More information:");
                                lineReader = new BufferedReader(new InputStreamReader(helpStream));
                                while ((helpLine = lineReader.readLine()) != null) {
                                    breaker = BreakIterator.getLineInstance(Locale.US);
                                    breaker.setText(helpLine);
                                    start = breaker.first();
                                    endOk = 0;
                                    end = 0;
                                    while (end != -1) {
                                        end = breaker.next();
                                        if (end == -1 || end - start - (Character.isWhitespace(helpLine.charAt(end - 1)) != false ? 1 : 0) > 80) {
                                            output.print(StringUtils.trimRight((String)helpLine.substring(start, endOk)));
                                            output.println();
                                            start = endOk;
                                            endOk = end;
                                        }
                                        endOk = end;
                                    }
                                }
                            }
                            finally {
                                IOUtils.close((Closeable)helpStream);
                            }
                        }
                        return problem == null || command.isHelp() != false ? AbstractCommand.EXIT_OK : AbstractCommand.EXIT_ERROR;
                    }
                    try {
                        return command.run();
                    }
                    catch (Throwable e) {
                        ExceptionUtils.deeplyPrint((Throwable)e, (PrintStream)System.err, (boolean)command.isDisplayStacktrace());
                        break block22;
                    }
                }
                catch (CliException e) {
                    System.err.println(e.getMessage());
                    if (!verbose) break block22;
                    System.err.println();
                    System.err.println("Usage: b3 command [options...]");
                    globalParser = new CmdLineParser((Object)new EmptyCommand());
                    globalParser.printUsage((OutputStream)System.err);
                    System.err.println();
                    System.err.println("Available commands:");
                    availableCommands = Headless.getAvailableCommands();
                    if (availableCommands.size() <= 0) break block23;
                    ** for (command : availableCommands)
                }
lbl-1000:
                // 1 sources

                {
                    System.err.printf("%s - %s\n", new Object[]{command.getName(), command.getShortDescription()});
                    continue;
lbl76:
                    // 1 sources

                    break block22;
                }
            }
            System.err.println("None");
        }
        return AbstractCommand.EXIT_ERROR;
    }

    private static AbstractCommand createCommand(IConfigurationElement commandConfiguration) throws CoreException {
        AbstractCommand command = (AbstractCommand)commandConfiguration.createExecutableExtension(COMMAND_CLASS_ATTR);
        command.setName(commandConfiguration.getAttribute(COMMAND_NAME_ATTR));
        return command;
    }

    private static List<AbstractCommand> getAvailableCommands() throws CoreException {
        IConfigurationElement[] commandConfigurations = Headless.getCommandConfigurations();
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>(commandConfigurations.length);
        IConfigurationElement[] iConfigurationElementArray = commandConfigurations;
        int n = commandConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement commandConfiguration = iConfigurationElementArray[n2];
            commands.add(Headless.createCommand(commandConfiguration));
            ++n2;
        }
        Collections.sort(commands);
        return commands;
    }

    private static AbstractCommand getCommand(String string) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = Headless.getCommandConfigurations();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement commandConfiguration = iConfigurationElementArray[n2];
            if (commandConfiguration.getAttribute(COMMAND_NAME_ATTR).equals(string)) {
                return Headless.createCommand(commandConfiguration);
            }
            ++n2;
        }
        return null;
    }

    private static IConfigurationElement[] getCommandConfigurations() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(COMMAND_EXTENSION);
    }

    public Object start(IApplicationContext context) throws Exception {
        HeadlessActivator.getInstance().setHeadless();
        String[] args = (String[])context.getArguments().get("application.args");
        return Headless.run(args, true);
    }

    public void stop() {
    }
}

