/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.buckminster.generic.Messages;
import org.eclipse.buckminster.generic.plugin.AbstractPlugin;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class IoUtils {
    public static void close(AbstractPlugin plugin, Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            plugin.logError(NLS.bind((String)Messages.error_closing_instance_0, (Object)stream.getClass().getName()), e);
        }
    }

    public static void deleteFileOrFolder(File fileOrFolder) {
        File[] files = fileOrFolder.listFiles();
        if (files != null) {
            int idx = files.length;
            while (--idx >= 0) {
                IoUtils.deleteFileOrFolder(files[idx]);
            }
        }
        fileOrFolder.delete();
    }

    public static InputStream openInput(IFileStore fs, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            return fs.openInputStream(0, monitor);
        }
        catch (CoreException e) {
            Throwable cause = e.getStatus().getException();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw e;
        }
    }
}

