/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataCollector
extends CommandOutputListener {
    private static final int BEGIN = 0;
    private static final int HEADER = 1;
    private static final int REVISION = 3;
    private static final int NEXT_REV_OR_BEGIN = 4;
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    private static final String LOG_TIMESTAMP_FORMAT_OLD = "yyyy/MM/dd HH:mm:ss zzz";
    private static final Locale LOG_TIMESTAMP_LOCALE = Locale.US;
    private static final String NOTHING_KNOWN_ABOUT = "nothing known about ";
    private static final Pattern s_revDataExpr = Pattern.compile("^date:\\s*([^;]+);\\s*author:[^;]+;\\s*state:\\s*([^;]+);.*$", 2);
    private static final int SYMBOLIC_NAMES = 2;
    private final HashSet<String> m_branches = new HashSet();
    private final HashSet<String> m_tags = new HashSet();
    private Date m_lastModificationTime;
    private int m_state = 0;

    private static Date convertFromLogTime(String modTime) {
        if (modTime == null) {
            return null;
        }
        String timestampFormat = LOG_TIMESTAMP_FORMAT;
        if (modTime.length() > 4 && modTime.charAt(4) == '/') {
            timestampFormat = LOG_TIMESTAMP_FORMAT_OLD;
        }
        SimpleDateFormat format = new SimpleDateFormat(timestampFormat, LOG_TIMESTAMP_LOCALE);
        try {
            return format.parse(modTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static boolean isBranchTag(String tagName) {
        int numberOfDots = 0;
        int lastDot = 0;
        int top = tagName.length();
        int i = 0;
        while (i < top) {
            if (tagName.charAt(i) == '.') {
                ++numberOfDots;
                lastDot = i;
            }
            ++i;
        }
        if (numberOfDots % 2 == 0) {
            return true;
        }
        if (numberOfDots == 1) {
            return false;
        }
        return tagName.charAt(lastDot - 1) == '0' && tagName.charAt(lastDot - 2) == '.';
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        String serverMessage = this.getServerMessage(line, location);
        if (serverMessage != null && serverMessage.startsWith(NOTHING_KNOWN_ABOUT)) {
            return new CVSStatus(4, -17, NLS.bind((String)CVSMessages.CVSStatus_messageWithRoot, (Object[])new String[]{commandRoot.getName(), line}), null);
        }
        return OK;
    }

    public Set<String> getBranchNames() {
        return this.m_branches;
    }

    public Date getLastModificationTime() {
        return this.m_lastModificationTime;
    }

    public Set<String> getTagNames() {
        return this.m_tags;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        switch (this.m_state) {
            case 0: {
                if (!line.startsWith("RCS file:")) break;
                this.m_state = 1;
                break;
            }
            case 1: 
            case 4: {
                if (line.startsWith("RCS file:")) {
                    this.m_state = 1;
                    break;
                }
                if (line.startsWith("revision ")) {
                    this.m_state = 3;
                    break;
                }
                if (!line.startsWith("symbolic names:")) break;
                this.m_state = 2;
                break;
            }
            case 2: {
                if (line.startsWith("keyword substitution:")) {
                    this.m_state = 1;
                    break;
                }
                this.symbolicName(line);
                break;
            }
            case 3: {
                this.revision(line, location);
            }
        }
        return OK;
    }

    private void revision(String line, ICVSRepositoryLocation location) {
        Matcher matcher = s_revDataExpr.matcher(line);
        if (matcher.matches()) {
            Date date = MetaDataCollector.convertFromLogTime(String.valueOf(matcher.group(1)) + " GMT");
            if (this.m_lastModificationTime == null || this.m_lastModificationTime.compareTo(date) < 0) {
                this.m_lastModificationTime = date;
            }
        }
        this.m_state = 4;
    }

    private void symbolicName(String line) {
        int firstColon = line.indexOf(58);
        String tag = line.substring(1, firstColon);
        String rev = line.substring(firstColon + 2);
        if (MetaDataCollector.isBranchTag(rev)) {
            this.m_branches.add(tag);
        } else {
            this.m_tags.add(tag);
        }
    }
}

