/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.maven.internal.GroupAndArtifact;
import org.eclipse.buckminster.maven.internal.GroupAndArtifactHandler;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MapEntryHandler
extends GroupAndArtifactHandler
implements ChildPoppedListener {
    private GroupAndArtifactHandler m_aliasHandler;
    private List<GroupAndArtifact> m_aliases;
    private String m_name;

    public MapEntryHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (this.m_aliases == null) {
            this.m_aliases = new ArrayList<GroupAndArtifact>();
        }
        this.m_aliases.add(((GroupAndArtifactHandler)child).createEntry());
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        GroupAndArtifactHandler ch;
        if (localName.equals("alias")) {
            if (this.m_aliasHandler == null) {
                this.m_aliasHandler = new GroupAndArtifactHandler((AbstractHandler)this);
            }
            ch = this.m_aliasHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        this.m_name = this.getStringValue(attrs, "name");
        if (this.m_aliases != null) {
            this.m_aliases.clear();
        }
    }

    GroupAndArtifact createEntry() {
        return new MapEntry(this.m_name, this.getGroup(), this.getArtifact(), this.m_aliases);
    }

    String getName() {
        return this.m_name;
    }
}

