/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.rmap.parser.BidirectionalTransformerHandler;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.MapEntryHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingsHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    private BidirectionalTransformerHandler m_transformerHandler;
    private MapEntryHandler m_mapEntryHandler;
    private TreeMap<String, MapEntry> m_entries;
    private List<BidirectionalTransformer> m_rules;

    public MappingsHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) {
        if (child instanceof MapEntryHandler) {
            if (this.m_entries == null) {
                this.m_entries = new TreeMap();
            }
            MapEntry entry = (MapEntry)((MapEntryHandler)child).createEntry();
            this.m_entries.put(entry.getName(), entry);
        } else if (child instanceof BidirectionalTransformerHandler) {
            if (this.m_rules == null) {
                this.m_rules = new ArrayList<BidirectionalTransformer>();
            }
            this.m_rules.add(((BidirectionalTransformerHandler)child).getTransformer());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        MapEntryHandler ch;
        if (localName.equals("entry")) {
            if (this.m_mapEntryHandler == null) {
                this.m_mapEntryHandler = new MapEntryHandler((AbstractHandler)this);
            }
            ch = this.m_mapEntryHandler;
        } else if (localName.equals("rule")) {
            if (this.m_transformerHandler == null) {
                this.m_transformerHandler = new BidirectionalTransformerHandler((AbstractHandler)this);
            }
            ch = this.m_transformerHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public Map<String, MapEntry> getEntriesAndClear() {
        TreeMap<String, MapEntry> entries = this.m_entries;
        this.m_entries = null;
        return entries == null ? Collections.emptyMap() : entries;
    }

    public List<BidirectionalTransformer> getRuleAndClear() {
        List<BidirectionalTransformer> rules = this.m_rules;
        this.m_rules = null;
        return rules == null ? Collections.emptyList() : rules;
    }
}

