/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.maven.internal.ILocationResolver;
import org.eclipse.buckminster.maven.internal.LocalCache;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.Maven2VersionFinder;
import org.eclipse.buckminster.maven.internal.MavenComponentType;
import org.eclipse.buckminster.maven.internal.MavenReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven2ReaderType
extends MavenReaderType {
    public static Document getMetadataDocument(DocumentBuilder docBld, URL url, LocalCache cache, IConnectContext cctx, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            AccessibleByteArrayOutputStream buffer = new AccessibleByteArrayOutputStream(8192, 0x100000);
            try {
                DownloadManager.readInto((URL)url, (IConnectContext)cctx, (OutputStream)buffer, (IProgressMonitor)monitor);
                return docBld.parse(buffer.getInputStream());
            }
            catch (SAXParseException e) {
                String msg = e.getMessage();
                if (msg == null || !msg.contains("UTF-8")) {
                    throw e;
                }
                InputSource input = new InputSource(buffer.getInputStream());
                input.setEncoding("ISO-8859-1");
                docBld.reset();
                return docBld.parse(input);
            }
        }
        catch (CoreException e) {
            docBld.reset();
            throw e;
        }
        catch (FileNotFoundException e) {
            docBld.reset();
            throw e;
        }
        catch (Exception e) {
            docBld.reset();
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static String getSnapshotVersion(Document doc, String version) {
        Element ts;
        Element buildNum;
        Element snapshotElement;
        String v = null;
        Element versioningElement = Maven2ReaderType.getElement(doc, "versioning");
        if (versioningElement != null && (snapshotElement = Maven2ReaderType.getElement(versioningElement, "snapshot")) != null && (buildNum = Maven2ReaderType.getElement(snapshotElement, "buildNumber")) != null && (ts = Maven2ReaderType.getElement(snapshotElement, "timestamp")) != null) {
            v = String.valueOf(version.substring(0, version.length() - 8)) + ts.getTextContent() + '-' + buildNum.getTextContent();
        }
        return v;
    }

    public static List<String> getVersions(Document doc) {
        Element versionsElement;
        ArrayList<String> versionList = null;
        Element versioningElement = Maven2ReaderType.getElement(doc, "versioning");
        if (versioningElement != null && (versionsElement = Maven2ReaderType.getElement(versioningElement, "versions")) != null) {
            NodeList versions = versionsElement.getElementsByTagName("version");
            int top = versions.getLength();
            int i = 0;
            while (i < top) {
                if (versionList == null) {
                    versionList = new ArrayList<String>();
                }
                versionList.add(versions.item(i).getTextContent());
                ++i;
            }
        }
        return versionList == null ? Collections.emptyList() : versionList;
    }

    private static Element getElement(Document doc, String elementName) {
        return Maven2ReaderType.getElement(doc.getElementsByTagName(elementName));
    }

    private static Element getElement(Element elem, String elementName) {
        return elem == null ? null : Maven2ReaderType.getElement(elem.getElementsByTagName(elementName));
    }

    private static Element getElement(NodeList nodeList) {
        return nodeList != null && nodeList.getLength() > 0 ? (Element)nodeList.item(0) : null;
    }

    @Override
    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new Maven2VersionFinder(this, provider, ctype, nodeQuery);
    }

    @Override
    void appendArtifactFolder(StringBuilder pbld, MapEntry mapEntry, VersionMatch vm) throws CoreException {
        String artifactPath = vm.getArtifactInfo();
        this.appendEntryFolder(pbld, mapEntry);
        pbld.append(artifactPath, 0, artifactPath.lastIndexOf(47) + 1);
    }

    void appendEntryFolder(StringBuilder pbld, MapEntry mapEntry) throws CoreException {
        StringTokenizer tokens = new StringTokenizer(mapEntry.getGroupId(), ".");
        while (tokens.hasMoreTokens()) {
            this.appendFolder(pbld, tokens.nextToken());
        }
        this.appendFolder(pbld, mapEntry.getArtifactId());
    }

    @Override
    void appendFileName(StringBuilder pbld, String artifactID, VersionMatch vm, String extension) throws CoreException {
        if (extension == null) {
            String artifactPath = vm.getArtifactInfo();
            pbld.append(artifactPath, artifactPath.lastIndexOf(47) + 1, artifactPath.length());
        } else {
            pbld.append(artifactID);
            pbld.append('-');
            pbld.append(VersionHelper.getOriginal((Version)vm.getVersion()));
            pbld.append(extension);
        }
    }

    @Override
    void appendPathToArtifact(StringBuilder pbld, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        this.appendEntryFolder(pbld, mapEntry);
        pbld.append(vs.getArtifactInfo());
    }

    @Override
    void appendPomFolder(StringBuilder pbld, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        this.appendArtifactFolder(pbld, mapEntry, vs);
    }

    VersionMatch createVersionMatch(DocumentBuilder docBld, ILocationResolver resolver, MapEntry mapEntry, VersionRange range, String versionStr) throws CoreException {
        Version version;
        URI uri = resolver.getURI();
        StringBuilder pbld = new StringBuilder();
        this.appendFolder(pbld, uri.getPath());
        this.appendEntryFolder(pbld, mapEntry);
        String rootPath = pbld.toString();
        String v = versionStr;
        if (v.endsWith("SNAPSHOT")) {
            try {
                LocalCache lc = this.getLocalCache();
                Document doc = Maven2ReaderType.getMetadataDocument(docBld, Maven2ReaderType.createURL(uri, String.valueOf(rootPath) + v + "/" + "maven-metadata.xml"), lc, resolver.getConnectContext(), (IProgressMonitor)new NullProgressMonitor());
                v = Maven2ReaderType.getSnapshotVersion(doc, v);
                if (v == null) {
                    return null;
                }
            }
            catch (CoreException e) {
                resolver.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{v, e.getMessage()});
                return null;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        if (range == null) {
            version = MavenComponentType.createVersion(v);
        } else {
            try {
                version = range.getFormat().parse(v);
                if (!range.isIncluded(version)) {
                    return null;
                }
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        pbld.setLength(0);
        pbld.append(versionStr);
        pbld.append('/');
        pbld.append(mapEntry.getArtifactId());
        pbld.append('-');
        pbld.append(VersionHelper.getOriginal((Version)version));
        pbld.append(".jar");
        return new VersionMatch(version, null, -1L, null, pbld.toString());
    }

    @Override
    VersionMatch createVersionMatch(ILocationResolver resolver, MapEntry mapEntry, String versionStr) throws CoreException {
        if (versionStr == null) {
            return super.createVersionMatch(resolver, mapEntry, versionStr);
        }
        try {
            VersionMatch vm = this.createVersionMatch(DocumentBuilderFactory.newInstance().newDocumentBuilder(), resolver, mapEntry, null, versionStr);
            if (vm == null) {
                vm = super.createVersionMatch(resolver, mapEntry, versionStr);
            }
            return vm;
        }
        catch (ParserConfigurationException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    IPath getDefaultLocalRepoPath() {
        return Maven2VersionFinder.getDefaultLocalRepoPath();
    }

    @Override
    String getMaterializationFolder() {
        return "maven2";
    }

    @Override
    void setPackaging(ProviderMatch providerMatch, String packaging) {
        VersionMatch vm = providerMatch.getVersionMatch();
        String artifactInfo = vm.getArtifactInfo();
        int suffixDelim = artifactInfo.lastIndexOf(46);
        artifactInfo = String.valueOf(artifactInfo.substring(0, suffixDelim + 1)) + packaging;
        providerMatch.setVersionMatch(new VersionMatch(vm.getVersion(), vm.getBranchOrTag(), vm.getRevision(), vm.getTimestamp(), artifactInfo));
    }
}

