/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.ctype.IResolutionBuilder;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.MissingVersionTypeException;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.maven.MavenPlugin;
import org.eclipse.buckminster.maven.Messages;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.MavenCSpecBuilder;
import org.eclipse.buckminster.maven.internal.MavenProvider;
import org.eclipse.buckminster.maven.internal.MavenReader;
import org.eclipse.buckminster.maven.internal.MavenReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenComponentType
extends AbstractComponentType {
    public static final String ID = "maven";
    private static final MavenCSpecBuilder s_builder = new MavenCSpecBuilder();
    private static SimpleDateFormat s_dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
    private static SimpleDateFormat s_timestampFormat = new SimpleDateFormat("yyyyMMdd'.'HHmmss", Locale.US);
    private static final Pattern s_timestampPattern = Pattern.compile("^((?:19|20)\\d{2}(?:0[1-9]|1[012])(?:0[1-9]|[12][0-9]|3[01]))(?:\\.((?:[01][0-9]|2[0-3])[0-5][0-9][0-5][0-9]))?$");

    public static Version createVersion(String versionStr) throws CoreException {
        if ((versionStr = TextUtils.notEmptyTrimmedString((String)versionStr)) == null) {
            return null;
        }
        Matcher m = s_timestampPattern.matcher(versionStr);
        if (m.matches()) {
            return VersionHelper.getVersionType((String)"Timestamp").getFormat().parse(versionStr);
        }
        try {
            return MavenComponentType.getTripletFormat().parse(versionStr);
        }
        catch (IllegalArgumentException e) {
            return VersionHelper.getVersionType((String)"String").getFormat().parse(versionStr);
        }
    }

    static String addDependencies(IComponentReader reader, Document pomDoc, CSpecBuilder cspec, GroupBuilder archives, ExpandingProperties<String> properties) throws CoreException {
        Element project = pomDoc.getDocumentElement();
        Node parentNode = null;
        Node propertiesNode = null;
        Node dependenciesNode = null;
        String groupId = null;
        String artifactId = null;
        String versionStr = null;
        String packaging = "jar";
        Node child = project.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if ("parent".equals(nodeName)) {
                    parentNode = child;
                } else if ("properties".equals(nodeName)) {
                    propertiesNode = child;
                } else if ("dependencies".equals(nodeName)) {
                    dependenciesNode = child;
                } else if ("groupId".equals(nodeName)) {
                    groupId = child.getTextContent().trim();
                } else if ("artifactId".equals(nodeName)) {
                    artifactId = child.getTextContent().trim();
                } else if ("version".equals(nodeName)) {
                    versionStr = child.getTextContent().trim();
                } else if ("packaging".equals(nodeName)) {
                    packaging = child.getTextContent().trim();
                }
            }
            child = child.getNextSibling();
        }
        if (reader instanceof MavenReader && parentNode != null) {
            MavenComponentType.processParentNode((MavenReader)reader, cspec, archives, properties, parentNode);
        }
        if (groupId != null) {
            groupId = (String)ExpandingProperties.expand(properties, groupId, (int)0);
            properties.put("project.groupId", (Object)groupId, true);
            properties.put("pom.groupId", (Object)groupId, true);
            properties.put("groupId", (Object)groupId, true);
        }
        if (artifactId != null) {
            artifactId = (String)ExpandingProperties.expand(properties, artifactId, (int)0);
            properties.put("project.artifactId", (Object)artifactId, true);
            properties.put("pom.artifactId", (Object)artifactId, true);
            properties.put("artifactId", (Object)artifactId, true);
        }
        if (versionStr != null) {
            versionStr = (String)ExpandingProperties.expand(properties, versionStr, (int)0);
            properties.put("project.version", (Object)versionStr, true);
            properties.put("pom.version", (Object)versionStr, true);
            properties.put("version", (Object)versionStr, true);
        }
        if (propertiesNode != null) {
            MavenComponentType.processProperties(properties, propertiesNode);
        }
        if (dependenciesNode != null) {
            Provider provider = reader.getProviderMatch().getProvider();
            ComponentQuery query = reader.getNodeQuery().getComponentQuery();
            Node dep = dependenciesNode.getFirstChild();
            while (dep != null) {
                if (dep.getNodeType() == 1 && "dependency".equals(dep.getNodeName())) {
                    MavenComponentType.addDependency(query, provider, cspec, archives, properties, dep);
                }
                dep = dep.getNextSibling();
            }
        }
        return packaging;
    }

    static Date createTimestamp(String date, String time) throws CoreException {
        try {
            return time != null ? s_timestampFormat.parse(String.valueOf(date) + '.' + time) : s_dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    static VersionMatch createVersionMatch(String versionStr, String typeInfo) throws CoreException {
        Version version = MavenComponentType.createVersion(versionStr);
        if (version == null) {
            return VersionMatch.DEFAULT;
        }
        return new VersionMatch(version, null, -1L, null, typeInfo);
    }

    static VersionRange createVersionRange(String versionStr) throws CoreException {
        if (versionStr == null || versionStr.length() == 0) {
            return null;
        }
        char leadIn = versionStr.charAt(0);
        if (leadIn == '[' || leadIn == '(') {
            if (leadIn == '[' && versionStr.endsWith(",)")) {
                Version version = MavenComponentType.createVersion(versionStr = versionStr.substring(1, versionStr.length() - 2));
                return version == null ? null : VersionHelper.greaterOrEqualRange((Version)version);
            }
            return VersionHelper.createRange((VersionFormat)MavenComponentType.getTripletFormat(), (String)versionStr);
        }
        Version version = MavenComponentType.createVersion(versionStr);
        if (version == null) {
            return null;
        }
        return VersionHelper.exactRange((Version)version);
    }

    static VersionFormat getTripletFormat() {
        try {
            return VersionHelper.getVersionType((String)"Triplet").getFormat();
        }
        catch (MissingVersionTypeException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isSnapshotVersion(Version version) {
        return version != null && version.toString().endsWith("SNAPSHOT");
    }

    static Version stripFromSnapshot(Version version) {
        if (version == null) {
            return null;
        }
        String vstr = version.toString();
        if (vstr.endsWith("SNAPSHOT")) {
            int stripLen = 8;
            if (vstr.charAt(vstr.length() - (stripLen + 1)) == '-') {
                ++stripLen;
            }
            vstr = vstr.substring(0, vstr.length() - stripLen);
        }
        try {
            return version.getFormat().parse(vstr);
        }
        catch (IllegalArgumentException e) {
            return version;
        }
    }

    private static void addDependency(ComponentQuery query, Provider provider, CSpecBuilder cspec, GroupBuilder archives, ExpandingProperties<String> properties, Node dep) throws CoreException {
        block24: {
            String componentName;
            String id = null;
            String groupId = null;
            String artifactId = null;
            String versionStr = null;
            String type = null;
            boolean optional = false;
            Node depChild = dep.getFirstChild();
            while (depChild != null) {
                if (depChild.getNodeType() == 1) {
                    String localName = depChild.getNodeName();
                    String nodeValue = depChild.getTextContent().trim();
                    if ("groupId".equals(localName)) {
                        groupId = nodeValue;
                    } else if ("artifactId".equals(localName)) {
                        artifactId = nodeValue;
                    } else if ("version".equals(localName)) {
                        versionStr = nodeValue;
                    } else if ("id".equals(localName)) {
                        id = nodeValue;
                    } else if ("type".equals(localName)) {
                        type = nodeValue;
                    } else if ("optional".equals(localName)) {
                        optional = Boolean.parseBoolean(nodeValue);
                    }
                }
                depChild = depChild.getNextSibling();
            }
            if (optional) {
                return;
            }
            if (artifactId == null) {
                artifactId = id;
            }
            if (artifactId == null) {
                return;
            }
            if ("plugin".equals(type)) {
                return;
            }
            if (groupId == null) {
                groupId = artifactId;
            }
            artifactId = (String)ExpandingProperties.expand(properties, artifactId, (int)0);
            groupId = (String)ExpandingProperties.expand(properties, (Object)groupId, (int)0);
            if (versionStr != null) {
                versionStr = (String)ExpandingProperties.expand(properties, (Object)versionStr, (int)0);
            }
            String string = componentName = provider instanceof MavenProvider ? ((MavenProvider)provider).getComponentName(groupId, artifactId) : MavenProvider.getDefaultName(groupId, artifactId);
            if (componentName.contains("${")) {
                MavenPlugin.getLogger().warning(NLS.bind((String)Messages.unable_to_resolve_component_name_0_skipping_dependency, (Object)componentName), new Object[0]);
                return;
            }
            ComponentName adviceKey = new ComponentName(componentName, ID);
            if (query.skipComponent(adviceKey)) {
                return;
            }
            ComponentRequestBuilder depBld = cspec.createDependencyBuilder();
            depBld.setName(componentName);
            depBld.setComponentTypeID(ID);
            VersionRange vd = query.getVersionOverride(adviceKey);
            if (vd == null) {
                vd = MavenComponentType.createVersionRange(versionStr);
            }
            depBld.setVersionRange(vd);
            try {
                cspec.addDependency((IComponentRequest)depBld);
                archives.addExternalPrerequisite(componentName, ID, "java.binaries");
            }
            catch (PrerequisiteAlreadyDefinedException e) {
                ComponentRequestBuilder oldDep = cspec.getRequiredDependency(depBld.getName(), depBld.getComponentTypeID());
                if (Trivial.equalsAllowNull((Object)vd, (Object)oldDep.getVersionRange())) break block24;
                MavenPlugin.getLogger().warning(e.getMessage(), new Object[0]);
            }
        }
    }

    private static void processParentNode(MavenReader reader, CSpecBuilder cspec, GroupBuilder archives, ExpandingProperties<String> properties, Node parent) throws CoreException {
        Provider provider;
        String groupId = null;
        String artifactId = null;
        String versionStr = null;
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String localName = child.getNodeName();
                String nodeValue = child.getTextContent().trim();
                if ("groupId".equals(localName)) {
                    groupId = nodeValue;
                } else if ("artifactId".equals(localName)) {
                    artifactId = nodeValue;
                } else if ("version".equals(localName)) {
                    versionStr = nodeValue;
                }
            }
            child = child.getNextSibling();
        }
        if (groupId != null) {
            groupId = (String)ExpandingProperties.expand(properties, groupId, (int)0);
            properties.put("project.groupId", (Object)groupId, true);
            properties.put("pom.groupId", (Object)groupId, true);
            properties.put("groupId", (Object)groupId, true);
        }
        if (artifactId != null) {
            artifactId = (String)ExpandingProperties.expand(properties, artifactId, (int)0);
            properties.put("project.artifactId", (Object)artifactId, true);
            properties.put("pom.artifactId", (Object)artifactId, true);
            properties.put("artifactId", (Object)artifactId, true);
        }
        String componentName = (provider = reader.getProviderMatch().getProvider()) instanceof MavenProvider ? ((MavenProvider)provider).getComponentName(groupId, artifactId) : MavenProvider.getDefaultName(groupId, artifactId);
        MapEntry entry = new MapEntry(componentName, groupId, artifactId, null);
        MavenReaderType mrt = (MavenReaderType)reader.getReaderType();
        VersionMatch vm = mrt.createVersionMatch(reader, entry, versionStr);
        IPath parentPath = mrt.getPomPath(entry, vm);
        MavenPlugin.getLogger().debug("Getting POM information for parent: %s - %s at path %s", new Object[]{groupId, artifactId, parentPath});
        Document parentDoc = reader.getPOMDocument(entry, vm, parentPath, (IProgressMonitor)new NullProgressMonitor());
        if (parentDoc == null) {
            return;
        }
        MavenComponentType.addDependencies((IComponentReader)reader, parentDoc, cspec, archives, properties);
    }

    private static void processProperties(ExpandingProperties<String> properties, Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                String nodeValue = child.getTextContent().trim();
                if (nodeValue.length() > 0) {
                    properties.put(nodeName, (Object)((String)ExpandingProperties.expand(properties, (Object)nodeValue, (int)0)), true);
                } else {
                    properties.remove((Object)nodeName);
                }
            }
            child = child.getNextSibling();
        }
    }

    public IResolutionBuilder getResolutionBuilder(IComponentReader reader, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return s_builder;
    }

    public VersionRange getTypeSpecificDesignator(VersionRange range) {
        int micro;
        int minor;
        int major;
        boolean highIsSnapshot;
        if (range == null) {
            return null;
        }
        Version low = range.getMinimum();
        Version high = range.getMaximum();
        boolean lowIsSnapshot = MavenComponentType.isSnapshotVersion(low);
        boolean bl = highIsSnapshot = high != null && MavenComponentType.isSnapshotVersion(high);
        if (!lowIsSnapshot && !highIsSnapshot) {
            return range;
        }
        low = MavenComponentType.stripFromSnapshot(low);
        if (high != null) {
            high = MavenComponentType.stripFromSnapshot(high);
        }
        if (!low.isOSGiCompatible()) {
            return new VersionRange(low, range.getIncludeMinimum(), high, range.getIncludeMaximum());
        }
        StringBuilder bld = new StringBuilder();
        bld.append(MavenComponentType.getTripletFormat());
        bld.append('/');
        if (lowIsSnapshot) {
            if (high == null || range.getIncludeMinimum()) {
                bld.append('(');
                major = low.getMajor();
                minor = low.getMinor();
                micro = low.getMicro();
                if (minor > 0 || micro > 0) {
                    bld.append(major);
                    bld.append('.');
                    if (micro > 0) {
                        bld.append(minor);
                        bld.append('.');
                        bld.append(micro - 1);
                    } else {
                        bld.append(minor - 1);
                    }
                } else {
                    bld.append(major - 1);
                }
            } else {
                bld.append('[');
                bld.append(low);
            }
        } else {
            bld.append('[');
            bld.append(low);
        }
        bld.append(',');
        if (range.getMinimum().equals((Object)range.getMaximum())) {
            bld.append(low);
            bld.append(']');
        } else if (high == null) {
            bld.append(Integer.MAX_VALUE);
            bld.append(']');
        } else if (range.getIncludeMaximum()) {
            bld.append(high);
            bld.append(']');
        } else if (highIsSnapshot) {
            major = high.getMajor();
            minor = high.getMinor();
            micro = high.getMicro();
            if (minor > 0 || micro > 0) {
                bld.append(major);
                bld.append('.');
                if (micro > 0) {
                    bld.append(minor);
                    bld.append('.');
                    bld.append(micro - 1);
                } else {
                    bld.append(minor - 1);
                }
            } else {
                bld.append(major - 1);
            }
            bld.append(']');
        } else {
            bld.append(high);
            bld.append(')');
        }
        try {
            return new VersionRange(bld.toString());
        }
        catch (IllegalArgumentException e) {
            return range;
        }
    }
}

