/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.URLFileReader;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.maven.internal.ILocationResolver;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.MavenReaderType;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class MavenReader
extends URLFileReader
implements ILocationResolver {
    private final MapEntry m_mapEntry;

    public MavenReader(MavenReaderType readerType, ProviderMatch rInfo) throws CoreException {
        super((IReaderType)readerType, rInfo, readerType.getURI(rInfo));
        this.m_mapEntry = MavenReaderType.getGroupAndArtifact(rInfo.getProvider(), rInfo.getNodeQuery().getComponentRequest());
    }

    public URL getURL() throws CoreException {
        return ((MavenReaderType)this.getReaderType()).getArtifactURL(this.getURI(), this.m_mapEntry, this.getVersionMatch());
    }

    public InputStream open(IProgressMonitor monitor) throws CoreException, IOException {
        IPath artifactPath = ((MavenReaderType)this.getReaderType()).getArtifactPath(this.m_mapEntry, this.getVersionMatch());
        return ((MavenReaderType)this.getReaderType()).getLocalCache().openFile(this.getURI().toURL(), this.getConnectContext(), artifactPath, monitor);
    }

    Document getPOMDocument(IProgressMonitor monitor) throws CoreException {
        MavenReaderType rt = (MavenReaderType)this.getReaderType();
        VersionMatch vs = this.getVersionMatch();
        IPath pomPath = rt.getPomPath(this.m_mapEntry, vs);
        return this.getPOMDocument(this.m_mapEntry, vs, pomPath, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document getPOMDocument(MapEntry entry, VersionMatch vs, IPath pomPath, IProgressMonitor monitor) throws CoreException {
        Document document;
        MavenReaderType rt = (MavenReaderType)this.getReaderType();
        URI repoURI = this.getURI();
        InputStream input = null;
        monitor.beginTask(null, 2000);
        {
            URL repoURL = repoURI.toURL();
            input = rt.getLocalCache().openFile(repoURI.toURL(), this.getConnectContext(), pomPath, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            String repoPath = repoURL.getPath();
            if (!repoPath.endsWith("/")) {
                repoPath = String.valueOf(repoPath) + "/";
            }
            repoPath = String.valueOf(repoPath) + pomPath;
            try {
                InputSource source = new InputSource(new BufferedInputStream(input));
                source.setSystemId(new URI(repoURI.getScheme(), repoURI.getAuthority(), repoPath, repoURI.getQuery(), repoURI.getFragment()).toString());
                document = builder.parse(source);
            }
            catch (SAXParseException e) {
                String msg = e.getMessage();
                if (msg != null && msg.contains("UTF-8")) {
                    IOUtils.close((Closeable)input);
                    input = rt.getLocalCache().openFile(repoURI.toURL(), this.getConnectContext(), pomPath, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                    InputSource source = new InputSource(new BufferedInputStream(input));
                    source.setSystemId(new URI(repoURI.getScheme(), repoURI.getAuthority(), repoPath, repoURI.getQuery(), repoURI.getFragment()).toString());
                    source.setEncoding("ISO-8859-1");
                    builder.reset();
                    Document document2 = builder.parse(source);
                    IOUtils.close((Closeable)input);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)1000);
                    monitor.done();
                    return document2;
                }
                throw e;
            }
        }
        IOUtils.close((Closeable)input);
        MonitorUtils.worked((IProgressMonitor)monitor, (int)1000);
        monitor.done();
        return document;
    }

    VersionMatch getVersionMatch() throws CoreException {
        return this.getProviderMatch().getVersionMatch();
    }

    void setPackaging(String packaging) {
        ((MavenReaderType)this.getReaderType()).setPackaging(this.getProviderMatch(), packaging);
    }
}

