/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatingSystem implements Enumerator
{
    WIN32(0, "Win32", "win32"),
    LINUX(1, "Linux", "linux"),
    MAC_OSX(2, "MacOSX", "macosx");

    public static final int WIN32_VALUE = 0;
    public static final int LINUX_VALUE = 1;
    public static final int MAC_OSX_VALUE = 2;
    private static final OperatingSystem[] VALUES_ARRAY;
    public static final List<OperatingSystem> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperatingSystem[]{WIN32, LINUX, MAC_OSX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperatingSystem get(int value) {
        switch (value) {
            case 0: {
                return WIN32;
            }
            case 1: {
                return LINUX;
            }
            case 2: {
                return MAC_OSX;
            }
        }
        return null;
    }

    public static OperatingSystem get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatingSystem result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperatingSystem getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatingSystem result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private OperatingSystem(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

