/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.impl;

import java.net.URI;
import org.eclipse.buckminster.aggregator.AggregateType;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.AggregatorPackage;
import org.eclipse.buckminster.aggregator.Architecture;
import org.eclipse.buckminster.aggregator.Bundle;
import org.eclipse.buckminster.aggregator.Category;
import org.eclipse.buckminster.aggregator.Configuration;
import org.eclipse.buckminster.aggregator.Contact;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.CustomCategory;
import org.eclipse.buckminster.aggregator.DescriptionProvider;
import org.eclipse.buckminster.aggregator.ExclusionRule;
import org.eclipse.buckminster.aggregator.Feature;
import org.eclipse.buckminster.aggregator.InfosProvider;
import org.eclipse.buckminster.aggregator.InstallableUnitType;
import org.eclipse.buckminster.aggregator.MapRule;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.MavenItem;
import org.eclipse.buckminster.aggregator.MavenMapping;
import org.eclipse.buckminster.aggregator.MetadataRepositoryReference;
import org.eclipse.buckminster.aggregator.OperatingSystem;
import org.eclipse.buckminster.aggregator.PackedStrategy;
import org.eclipse.buckminster.aggregator.Product;
import org.eclipse.buckminster.aggregator.Property;
import org.eclipse.buckminster.aggregator.Status;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.buckminster.aggregator.ValidConfigurationsRule;
import org.eclipse.buckminster.aggregator.WindowSystem;
import org.eclipse.buckminster.aggregator.impl.AggregatorImpl;
import org.eclipse.buckminster.aggregator.impl.BundleImpl;
import org.eclipse.buckminster.aggregator.impl.CategoryImpl;
import org.eclipse.buckminster.aggregator.impl.ConfigurationImpl;
import org.eclipse.buckminster.aggregator.impl.ContactImpl;
import org.eclipse.buckminster.aggregator.impl.ContributionImpl;
import org.eclipse.buckminster.aggregator.impl.CustomCategoryImpl;
import org.eclipse.buckminster.aggregator.impl.DescriptionProviderImpl;
import org.eclipse.buckminster.aggregator.impl.ExclusionRuleImpl;
import org.eclipse.buckminster.aggregator.impl.FeatureImpl;
import org.eclipse.buckminster.aggregator.impl.InfosProviderImpl;
import org.eclipse.buckminster.aggregator.impl.MappedRepositoryImpl;
import org.eclipse.buckminster.aggregator.impl.MavenItemImpl;
import org.eclipse.buckminster.aggregator.impl.MavenMappingImpl;
import org.eclipse.buckminster.aggregator.impl.MetadataRepositoryReferenceImpl;
import org.eclipse.buckminster.aggregator.impl.ProductImpl;
import org.eclipse.buckminster.aggregator.impl.PropertyImpl;
import org.eclipse.buckminster.aggregator.impl.StatusImpl;
import org.eclipse.buckminster.aggregator.impl.ValidConfigurationsRuleImpl;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.util.InstallableUnitUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorFactoryImpl
extends EFactoryImpl
implements AggregatorFactory {
    @Deprecated
    public static AggregatorPackage getPackage() {
        return AggregatorPackage.eINSTANCE;
    }

    public static AggregatorFactory init() {
        try {
            AggregatorFactory theAggregatorFactory = (AggregatorFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/buckminster/2009/aggregator");
            if (theAggregatorFactory != null) {
                return theAggregatorFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new AggregatorFactoryImpl();
    }

    public String convertAggregateTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertArchitectureToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertInstallableUnitTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertOperatingSystemToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertPackedStrategyToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertStatusCodeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 27: {
                return this.convertAggregateTypeToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertOperatingSystemToString(eDataType, instanceValue);
            }
            case 29: {
                return this.convertWindowSystemToString(eDataType, instanceValue);
            }
            case 30: {
                return this.convertArchitectureToString(eDataType, instanceValue);
            }
            case 31: {
                return this.convertPackedStrategyToString(eDataType, instanceValue);
            }
            case 32: {
                return this.convertInstallableUnitTypeToString(eDataType, instanceValue);
            }
            case 33: {
                return this.convertStatusCodeToString(eDataType, instanceValue);
            }
            case 34: {
                return this.convertURIToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String convertWindowSystemToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return (EObject)this.createAggregator();
            }
            case 1: {
                return (EObject)this.createMappedRepository();
            }
            case 2: {
                return (EObject)this.createConfiguration();
            }
            case 3: {
                return (EObject)this.createContribution();
            }
            case 4: {
                return (EObject)this.createContact();
            }
            case 5: {
                return (EObject)this.createFeature();
            }
            case 6: {
                return (EObject)this.createBundle();
            }
            case 8: {
                return (EObject)this.createProduct();
            }
            case 9: {
                return (EObject)this.createProperty();
            }
            case 10: {
                return (EObject)this.createCategory();
            }
            case 11: {
                return (EObject)this.createCustomCategory();
            }
            case 15: {
                return (EObject)this.createExclusionRule();
            }
            case 16: {
                return (EObject)this.createValidConfigurationsRule();
            }
            case 17: {
                return (EObject)this.createMetadataRepositoryReference();
            }
            case 20: {
                return (EObject)this.createDescriptionProvider();
            }
            case 21: {
                return (EObject)this.createMavenMapping();
            }
            case 22: {
                return (EObject)this.createMavenItem();
            }
            case 24: {
                return (EObject)this.createStatus();
            }
            case 26: {
                return (EObject)this.createInfosProvider();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public AggregateType createAggregateTypeFromString(EDataType eDataType, String initialValue) {
        AggregateType result = AggregateType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public Aggregator createAggregator() {
        AggregatorImpl aggregator = new AggregatorImpl();
        return aggregator;
    }

    public Architecture createArchitectureFromString(EDataType eDataType, String initialValue) {
        Architecture result = Architecture.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public Bundle createBundle() {
        BundleImpl bundle = new BundleImpl();
        return bundle;
    }

    @Override
    public Category createCategory() {
        CategoryImpl category = new CategoryImpl();
        return category;
    }

    @Override
    public Configuration createConfiguration() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        return configuration;
    }

    @Override
    public Contact createContact() {
        ContactImpl contact = new ContactImpl();
        return contact;
    }

    @Override
    public Contribution createContribution() {
        ContributionImpl contribution = new ContributionImpl();
        return contribution;
    }

    @Override
    public CustomCategory createCustomCategory() {
        CustomCategoryImpl customCategory = new CustomCategoryImpl();
        return customCategory;
    }

    @Override
    public DescriptionProvider createDescriptionProvider() {
        DescriptionProviderImpl descriptionProvider = new DescriptionProviderImpl();
        return descriptionProvider;
    }

    @Override
    public ExclusionRule createExclusionRule() {
        ExclusionRuleImpl exclusionRule = new ExclusionRuleImpl();
        return exclusionRule;
    }

    @Override
    public Feature createFeature() {
        FeatureImpl feature = new FeatureImpl();
        return feature;
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 27: {
                return this.createAggregateTypeFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createOperatingSystemFromString(eDataType, initialValue);
            }
            case 29: {
                return this.createWindowSystemFromString(eDataType, initialValue);
            }
            case 30: {
                return this.createArchitectureFromString(eDataType, initialValue);
            }
            case 31: {
                return this.createPackedStrategyFromString(eDataType, initialValue);
            }
            case 32: {
                return this.createInstallableUnitTypeFromString(eDataType, initialValue);
            }
            case 33: {
                return this.createStatusCodeFromString(eDataType, initialValue);
            }
            case 34: {
                return this.createURIFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public InfosProvider createInfosProvider() {
        InfosProviderImpl infosProvider = new InfosProviderImpl();
        return infosProvider;
    }

    public InstallableUnitType createInstallableUnitTypeFromString(EDataType eDataType, String initialValue) {
        InstallableUnitType result = InstallableUnitType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public MappedRepository createMappedRepository() {
        MappedRepositoryImpl mappedRepository = new MappedRepositoryImpl();
        return mappedRepository;
    }

    @Override
    public MappedRepository createMappedRepository(MetadataRepository mdr) {
        MappedRepository mappedRepo = this.createMappedRepository();
        mappedRepo.setMetadataRepository(mdr);
        mappedRepo.setLocation(mdr.getLocation().toString());
        return mappedRepo;
    }

    @Override
    public MappedUnit createMappedUnit(InstallableUnit iu) {
        MappedUnit mu = null;
        switch (InstallableUnitUtils.getType(iu)) {
            case FEATURE: {
                mu = this.createFeature();
                break;
            }
            case CATEGORY: {
                mu = this.createCategory();
                break;
            }
            case BUNDLE: 
            case FRAGMENT: {
                mu = this.createBundle();
                break;
            }
            case PRODUCT: {
                mu = this.createProduct();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IU type");
            }
        }
        mu.setInstallableUnit(iu);
        return mu;
    }

    @Override
    public MapRule createMapRule(InstallableUnit iu, Class<? extends MapRule> ruleClass) {
        MapRule mr = null;
        if (ruleClass.isAssignableFrom(ExclusionRule.class)) {
            mr = this.createExclusionRule();
        } else if (ruleClass.isAssignableFrom(ValidConfigurationsRule.class)) {
            mr = this.createValidConfigurationsRule();
        } else {
            throw new IllegalArgumentException("Unknown rule class " + ruleClass);
        }
        mr.setInstallableUnit(iu);
        return mr;
    }

    @Override
    public MavenItem createMavenItem() {
        MavenItemImpl mavenItem = new MavenItemImpl();
        return mavenItem;
    }

    @Override
    public MavenMapping createMavenMapping() {
        MavenMappingImpl mavenMapping = new MavenMappingImpl();
        return mavenMapping;
    }

    @Override
    public MetadataRepositoryReference createMetadataRepositoryReference() {
        MetadataRepositoryReferenceImpl metadataRepositoryReference = new MetadataRepositoryReferenceImpl();
        return metadataRepositoryReference;
    }

    public OperatingSystem createOperatingSystemFromString(EDataType eDataType, String initialValue) {
        OperatingSystem result = OperatingSystem.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public PackedStrategy createPackedStrategyFromString(EDataType eDataType, String initialValue) {
        PackedStrategy result = PackedStrategy.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public Product createProduct() {
        ProductImpl product = new ProductImpl();
        return product;
    }

    @Override
    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    @Override
    public Property createProperty(String key, String value) {
        PropertyImpl property = new PropertyImpl(key, value);
        return property;
    }

    @Override
    public Status createStatus() {
        StatusImpl status = new StatusImpl();
        return status;
    }

    @Override
    public Status createStatus(StatusCode statusCode) {
        return StatusImpl.createStatus(statusCode);
    }

    @Override
    public Status createStatus(StatusCode statusCode, String message) {
        return StatusImpl.createStatus(statusCode, message);
    }

    public StatusCode createStatusCodeFromString(EDataType eDataType, String initialValue) {
        StatusCode result = StatusCode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return (URI)super.createFromString(eDataType, initialValue);
    }

    @Override
    public ValidConfigurationsRule createValidConfigurationsRule() {
        ValidConfigurationsRuleImpl validConfigurationsRule = new ValidConfigurationsRuleImpl();
        return validConfigurationsRule;
    }

    public WindowSystem createWindowSystemFromString(EDataType eDataType, String initialValue) {
        WindowSystem result = WindowSystem.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public AggregatorPackage getAggregatorPackage() {
        return (AggregatorPackage)this.getEPackage();
    }
}

