/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.impl;

import java.util.Collection;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.AggregatorPackage;
import org.eclipse.buckminster.aggregator.AggregatorPlugin;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.EnabledStatusProvider;
import org.eclipse.buckminster.aggregator.InfosProvider;
import org.eclipse.buckminster.aggregator.InstallableUnitReference;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.Status;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.util.GeneralUtils;
import org.eclipse.buckminster.aggregator.util.InstallableUnitUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstallableUnitReferenceImpl
extends MinimalEObjectImpl.Container
implements InstallableUnitReference {
    protected int eFlags = 0;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected InstallableUnit installableUnit;

    private static String getString(String key) {
        return AggregatorPlugin.INSTANCE.getString(key);
    }

    protected InstallableUnitReferenceImpl() {
    }

    public InstallableUnit basicGetInstallableUnit() {
        return this.installableUnit;
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getStatus();
            }
            case 1: {
                return this.getErrors();
            }
            case 2: {
                return this.getWarnings();
            }
            case 3: {
                return this.getInfos();
            }
            case 4: {
                if (resolve) {
                    return this.getInstallableUnit();
                }
                return this.basicGetInstallableUnit();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getStatus() != null;
            }
            case 1: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 2: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 3: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 4: {
                return this.installableUnit != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setInstallableUnit((InstallableUnit)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                return;
            }
            case 2: {
                this.getWarnings().clear();
                return;
            }
            case 3: {
                this.getInfos().clear();
                return;
            }
            case 4: {
                this.setInstallableUnit(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<String> getErrors() {
        this.errors = new BasicEList();
        if (!this.isMappedRepositoryBroken() && (this.getInstallableUnit() != null && Trivial.trim((String)this.getInstallableUnit().getId()) == null || this.getInstallableUnit() == null)) {
            this.errors.add((Object)InstallableUnitReferenceImpl.getString("_UI_ErrorMessage_InstallableUnitIsNotAvailable"));
        }
        return this.errors;
    }

    @Override
    public EList<String> getInfos() {
        this.infos = new BasicEList();
        if (this.getInstallableUnit() != null) {
            VersionedName versionedName = InstallableUnitUtils.getVersionedName(this.getInstallableUnit());
            Version latestVersion = this.getLatestVersion();
            if (latestVersion != null && latestVersion.compareTo((Object)versionedName.getVersion()) > 0) {
                this.infos.add((Object)(String.valueOf(InstallableUnitReferenceImpl.getString("_UI_InfoMessage_InstallableUnitIsAvailableInVersion")) + " " + GeneralUtils.stringifyVersion(latestVersion)));
            }
        }
        return this.infos;
    }

    @Override
    public InstallableUnit getInstallableUnit() {
        return this.isMappedRepositoryBroken() ? null : this.getInstallableUnitGen();
    }

    @Override
    public InstallableUnit getInstallableUnit(boolean forceResolve) {
        if (forceResolve) {
            return this.getInstallableUnit();
        }
        return this.basicGetInstallableUnit();
    }

    public InstallableUnit getInstallableUnitGen() {
        if (this.installableUnit != null && ((EObject)this.installableUnit).eIsProxy()) {
            InternalEObject oldInstallableUnit = (InternalEObject)this.installableUnit;
            this.installableUnit = (InstallableUnit)this.eResolveProxy(oldInstallableUnit);
            if (this.installableUnit != oldInstallableUnit && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldInstallableUnit, (Object)this.installableUnit));
            }
        }
        return this.installableUnit;
    }

    @Override
    public Version getLatestVersion() {
        VersionedName versionedName = InstallableUnitUtils.getVersionedName(this.getInstallableUnit());
        if (versionedName == null) {
            return null;
        }
        InstallableUnitQuery query = new InstallableUnitQuery(versionedName.getId());
        Collector ius = ((MappedRepository)this.eContainer()).getMetadataRepository().query((Query)new CompositeQuery(new Query[]{query, new LatestIUVersionQuery()}), new Collector(), (IProgressMonitor)new NullProgressMonitor());
        if (ius.size() <= 0) {
            ius = ((MappedRepository)this.eContainer()).getMetadataRepository().query((Query)query, new Collector(), (IProgressMonitor)new NullProgressMonitor());
        }
        if (ius.size() > 0) {
            InstallableUnit iu = (InstallableUnit)ius.toArray(InstallableUnit.class)[0];
            return iu.getVersion();
        }
        return null;
    }

    @Override
    public synchronized Status getStatus() {
        if (!this.isBranchDisabledOrMappedRepositoryBroken() && this.getInstallableUnit() != null && InstallableUnitUtils.getStatus(this.getInstallableUnit()).getCode() == StatusCode.BROKEN) {
            Version latestVersion = this.getLatestVersion();
            if (latestVersion != null) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, String.valueOf(InstallableUnitReferenceImpl.getString("_UI_InfoMessage_InstallableUnitIsAvailableInVersion")) + " " + GeneralUtils.stringifyVersion(latestVersion));
            }
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, InstallableUnitReferenceImpl.getString("_UI_ErrorMessage_InstallableUnitIsNotAvailable"));
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.warnings;
    }

    @Override
    public boolean isBranchDisabledOrMappedRepositoryBroken() {
        return !this.isBranchEnabled() || this.isMappedRepositoryBroken();
    }

    @Override
    public boolean isBranchEnabled() {
        if (this instanceof EnabledStatusProvider && !((EnabledStatusProvider)((Object)this)).isEnabled()) {
            return false;
        }
        MappedRepository mappedRepository = (MappedRepository)this.eContainer();
        if (mappedRepository == null) {
            return true;
        }
        if (!mappedRepository.isEnabled()) {
            return false;
        }
        Contribution contribution = (Contribution)((EObject)mappedRepository).eContainer();
        return contribution == null || contribution.isEnabled();
    }

    @Override
    public boolean isMappedRepositoryBroken() {
        MappedRepository repo = (MappedRepository)this.eContainer();
        return repo == null || repo.getMetadataRepository() == null;
    }

    @Override
    public void setInstallableUnit(InstallableUnit newInstallableUnit) {
        InstallableUnit oldInstallableUnit = this.installableUnit;
        this.installableUnit = newInstallableUnit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldInstallableUnit, (Object)this.installableUnit));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.INSTALLABLE_UNIT_REFERENCE;
    }
}

