/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.impl;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.AggregatorPackage;
import org.eclipse.buckminster.aggregator.InfosProvider;
import org.eclipse.buckminster.aggregator.MavenItem;
import org.eclipse.buckminster.aggregator.MavenMapping;
import org.eclipse.buckminster.aggregator.Status;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.buckminster.aggregator.util.GeneralUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenMappingImpl
extends MinimalEObjectImpl.Container
implements MavenMapping {
    private Pattern compiledPattern;
    protected int eFlags = 0;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected static final String NAME_PATTERN_EDEFAULT = null;
    protected String namePattern = NAME_PATTERN_EDEFAULT;
    protected static final String GROUP_ID_EDEFAULT = null;
    protected String groupId = GROUP_ID_EDEFAULT;
    protected static final String ARTIFACT_ID_EDEFAULT = null;
    protected String artifactId = ARTIFACT_ID_EDEFAULT;

    public MavenMappingImpl(String namePattern, String groupId, String artifactId) {
        this.setNamePattern(namePattern);
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
    }

    protected MavenMappingImpl() {
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getStatus();
            }
            case 1: {
                return this.getErrors();
            }
            case 2: {
                return this.getWarnings();
            }
            case 3: {
                return this.getInfos();
            }
            case 4: {
                return this.getNamePattern();
            }
            case 5: {
                return this.getGroupId();
            }
            case 6: {
                return this.getArtifactId();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getStatus() != null;
            }
            case 1: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 2: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 3: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 4: {
                return NAME_PATTERN_EDEFAULT == null ? this.namePattern != null : !NAME_PATTERN_EDEFAULT.equals(this.namePattern);
            }
            case 5: {
                return GROUP_ID_EDEFAULT == null ? this.groupId != null : !GROUP_ID_EDEFAULT.equals(this.groupId);
            }
            case 6: {
                return ARTIFACT_ID_EDEFAULT == null ? this.artifactId != null : !ARTIFACT_ID_EDEFAULT.equals(this.artifactId);
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setNamePattern((String)newValue);
                return;
            }
            case 5: {
                this.setGroupId((String)newValue);
                return;
            }
            case 6: {
                this.setArtifactId((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                return;
            }
            case 2: {
                this.getWarnings().clear();
                return;
            }
            case 3: {
                this.getInfos().clear();
                return;
            }
            case 4: {
                this.setNamePattern(NAME_PATTERN_EDEFAULT);
                return;
            }
            case 5: {
                this.setGroupId(GROUP_ID_EDEFAULT);
                return;
            }
            case 6: {
                this.setArtifactId(ARTIFACT_ID_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public EList<String> getErrors() {
        if (this.errors == null) {
            this.errors = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 1);
        }
        return this.errors;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 3);
        }
        return this.infos;
    }

    @Override
    public String getNamePattern() {
        return this.namePattern;
    }

    @Override
    public Status getStatus() {
        try {
            String pattern = GeneralUtils.trimmedOrNull(this.getNamePattern());
            if (pattern == null || GeneralUtils.trimmedOrNull(this.getGroupId()) == null || GeneralUtils.trimmedOrNull(this.getArtifactId()) == null) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
            }
            this.compiledPattern = Pattern.compile(pattern);
            this.checkReplacements(this.compiledPattern, this.getGroupId(), this.getArtifactId());
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
        }
        catch (PatternSyntaxException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        catch (IndexOutOfBoundsException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.warnings;
    }

    @Override
    public MavenItem map(String installableUnitID) {
        Matcher m;
        if (this.compiledPattern != null && (m = this.compiledPattern.matcher(installableUnitID)).matches()) {
            MavenItem item = AggregatorFactory.eINSTANCE.createMavenItem();
            item.setGroupId(m.replaceFirst(this.getGroupId()));
            item.setArtifactId(m.replaceFirst(this.getArtifactId()));
            return item;
        }
        throw new RuntimeException("Mapping pattern is null");
    }

    @Override
    public void setArtifactId(String newArtifactId) {
        String oldArtifactId = this.artifactId;
        this.artifactId = newArtifactId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldArtifactId, (Object)this.artifactId));
        }
    }

    @Override
    public void setGroupId(String newGroupId) {
        String oldGroupId = this.groupId;
        this.groupId = newGroupId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldGroupId, (Object)this.groupId));
        }
    }

    @Override
    public void setNamePattern(String newNamePattern) {
        String oldNamePattern = this.namePattern;
        this.namePattern = newNamePattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldNamePattern, (Object)this.namePattern));
        }
        if (newNamePattern != null) {
            if (!newNamePattern.equals(oldNamePattern)) {
                try {
                    this.compiledPattern = Pattern.compile(GeneralUtils.trimmedOrNull(newNamePattern));
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
        } else {
            this.compiledPattern = null;
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", namePattern: ");
        result.append(this.namePattern);
        result.append(", groupId: ");
        result.append(this.groupId);
        result.append(", artifactId: ");
        result.append(this.artifactId);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.MAVEN_MAPPING;
    }

    private void checkReplacements(Pattern pattern, String ... replacements) {
        String emptyString = "";
        String auxGroup = "(.*)";
        Matcher matcher = this.compiledPattern.matcher(emptyString);
        StringBuilder auxPatternBuilder = new StringBuilder();
        int i = matcher.groupCount();
        while (i > 0) {
            auxPatternBuilder.append(auxGroup);
            --i;
        }
        Pattern auxPattern = Pattern.compile(auxPatternBuilder.toString());
        Matcher auxMatcher = auxPattern.matcher(emptyString);
        String[] stringArray = replacements;
        int n = replacements.length;
        int n2 = 0;
        while (n2 < n) {
            String replacement = stringArray[n2];
            auxMatcher.replaceAll(replacement);
            ++n2;
        }
    }
}

