/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.impl;

import org.eclipse.buckminster.aggregator.AggregatorPackage;
import org.eclipse.buckminster.aggregator.Status;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

public class StatusImpl
extends MinimalEObjectImpl.Container
implements Status {
    private static final Status s_okStatus = new StatusImpl(StatusCode.OK);
    private static final Status s_brokenStatus = new StatusImpl(StatusCode.BROKEN);
    private static final Status s_waitingStatus = new StatusImpl(StatusCode.WAITING);
    protected int eFlags = 0;
    protected static final StatusCode CODE_EDEFAULT = StatusCode.OK;
    protected static final int CODE_EFLAG_OFFSET = 0;
    protected static final int CODE_EFLAG_DEFAULT = CODE_EDEFAULT.ordinal() << 0;
    private static final StatusCode[] CODE_EFLAG_VALUES = StatusCode.values();
    protected static final int CODE_EFLAG = 3;
    protected static final String MESSAGE_EDEFAULT = "";
    protected String message = "";

    public static Status createStatus(StatusCode statusCode) {
        switch (statusCode) {
            case BROKEN: {
                return s_brokenStatus;
            }
            case WAITING: {
                return s_waitingStatus;
            }
        }
        return s_okStatus;
    }

    public static Status createStatus(StatusCode statusCode, String message) {
        return new StatusImpl(statusCode, message);
    }

    protected StatusImpl() {
    }

    protected StatusImpl(StatusCode statusCode) {
        this(statusCode, null);
    }

    protected StatusImpl(StatusCode statusCode, String message) {
        this.eFlags = this.eFlags & 0xFFFFFFFC | statusCode.ordinal() << 0;
        this.message = message;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getCode();
            }
            case 1: {
                return this.getMessage();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return (this.eFlags & 3) != CODE_EFLAG_DEFAULT;
            }
            case 1: {
                return MESSAGE_EDEFAULT == null ? this.message != null : !MESSAGE_EDEFAULT.equals(this.message);
            }
        }
        return super.eIsSet(featureID);
    }

    public StatusCode getCode() {
        return CODE_EFLAG_VALUES[(this.eFlags & 3) >>> 0];
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (code: ");
        result.append((Object)CODE_EFLAG_VALUES[(this.eFlags & 3) >>> 0]);
        result.append(", message: ");
        result.append(this.message);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.STATUS;
    }
}

