/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.p2.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.ChildrenProvider;
import org.eclipse.buckminster.aggregator.InstallableUnitType;
import org.eclipse.buckminster.aggregator.MetadataRepositoryReference;
import org.eclipse.buckminster.aggregator.Property;
import org.eclipse.buckminster.aggregator.Status;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.buckminster.aggregator.StatusProvider;
import org.eclipse.buckminster.aggregator.loader.IRepositoryLoader;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.p2.P2Factory;
import org.eclipse.buckminster.aggregator.p2.impl.MetadataRepositoryImpl;
import org.eclipse.buckminster.aggregator.p2view.Bundle;
import org.eclipse.buckminster.aggregator.p2view.Categories;
import org.eclipse.buckminster.aggregator.p2view.Category;
import org.eclipse.buckminster.aggregator.p2view.Feature;
import org.eclipse.buckminster.aggregator.p2view.Fragment;
import org.eclipse.buckminster.aggregator.p2view.IUPresentation;
import org.eclipse.buckminster.aggregator.p2view.MetadataRepositoryStructuredView;
import org.eclipse.buckminster.aggregator.p2view.OtherIU;
import org.eclipse.buckminster.aggregator.p2view.P2viewFactory;
import org.eclipse.buckminster.aggregator.p2view.Product;
import org.eclipse.buckminster.aggregator.util.GeneralUtils;
import org.eclipse.buckminster.aggregator.util.InstallableUnitUtils;
import org.eclipse.buckminster.aggregator.util.ResourceDiagnosticImpl;
import org.eclipse.buckminster.aggregator.util.ResourceUtils;
import org.eclipse.buckminster.aggregator.util.TimeUtils;
import org.eclipse.buckminster.aggregator.util.TwoColumnMatrix;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRepositoryResourceImpl
extends ResourceImpl
implements StatusProvider {
    private static final String NOTIFICATION_KEY = "notification";
    private AsynchronousLoader m_asynchronousLoader;
    private IRepositoryLoader m_loader;
    private MetadataRepositoryStructuredView repoView;
    private final TwoColumnMatrix<IUPresentation, Object[]> allIUPresentationMatrix = new TwoColumnMatrix();
    private Exception m_lastException = null;
    private boolean m_forceReload = false;
    private RepositoryLoaderJob m_loadingJob;
    private Diagnostic m_diagnostic;
    private Status m_status = AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);

    public static void cancelLoadRepository(String nature, String repositoryLocation, Aggregator aggregator) {
        Resource mdr = MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, repositoryLocation, aggregator);
        if (mdr instanceof MetadataRepositoryResourceImpl) {
            ((MetadataRepositoryResourceImpl)mdr).cancelLoadingJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResourceForNatureAndLocation(String nature, String repositoryLocation, Aggregator aggregator) {
        if (nature == null || repositoryLocation == null) {
            return null;
        }
        ResourceSet topSet = ((EObject)aggregator).eResource().getResourceSet();
        char c = repositoryLocation.charAt(repositoryLocation.length() - 1);
        if (c == '/' || c == '\\') {
            repositoryLocation = repositoryLocation.substring(0, repositoryLocation.length() - 1);
        }
        URI repoURI = MetadataRepositoryResourceImpl.getResourceUriForNatureAndLocation(nature, repositoryLocation);
        Resource mdr = null;
        ResourceSet resourceSet = topSet;
        synchronized (resourceSet) {
            mdr = topSet.getResource(repoURI, false);
            if (mdr == null) {
                mdr = topSet.createResource(repoURI);
            }
        }
        if (!(mdr instanceof MetadataRepositoryResourceImpl)) {
            topSet.getResources().remove((Object)mdr);
            mdr = null;
        }
        return mdr;
    }

    public static URI getResourceUriForNatureAndLocation(String nature, String location) {
        return URI.createGenericURI((String)nature, (String)location, null);
    }

    private static Throwable unwrap(Exception loadException) {
        Throwable rootCauseCandidate = loadException;
        while (rootCauseCandidate.getCause() != null) {
            rootCauseCandidate = rootCauseCandidate.getCause();
        }
        return rootCauseCandidate;
    }

    public MetadataRepositoryResourceImpl(URI uri, IRepositoryLoader loader) {
        super(uri);
        this.m_loader = loader;
    }

    public synchronized void cancelLoadingJob() {
        if (this.m_loadingJob != null) {
            this.m_loadingJob.cancel();
        }
    }

    public Object[] findIUPresentation(Pattern iuIdPattern, VersionRange iuVersionRange, Object[] startAfterPath, boolean forward) {
        List<Object> firstNodePath = null;
        firstNodePath = startAfterPath != null && startAfterPath[0] == this && startAfterPath.length > 1 ? this.getFirstNode(startAfterPath, forward) : this.getFirstNode(null, forward);
        if (firstNodePath == null) {
            return null;
        }
        List<Object> foundIUPath = this.findIU(firstNodePath, iuIdPattern, iuVersionRange, forward);
        return foundIUPath == null ? null : foundIUPath.toArray();
    }

    public TwoColumnMatrix<IUPresentation, Object[]> findIUPresentations(Pattern iuIdPattern, VersionRange iuVersionRange, boolean skipCategoriesSubTree) {
        TwoColumnMatrix<IUPresentation, Object[]> found = new TwoColumnMatrix<IUPresentation, Object[]>();
        int i = 0;
        while (i < this.allIUPresentationMatrix.size()) {
            InstallableUnit iu;
            IUPresentation iup = this.allIUPresentationMatrix.getKey(i);
            if (iup != null && iuIdPattern.matcher((iu = iup.getInstallableUnit()).getId()).find() && iuVersionRange.isIncluded(iu.getVersion()) && (!skipCategoriesSubTree || !(this.allIUPresentationMatrix.getValue(i)[2] instanceof Categories))) {
                found.add(iup, this.allIUPresentationMatrix.getValue(i));
            }
            ++i;
        }
        return found;
    }

    public TwoColumnMatrix<IUPresentation, Object[]> findIUPresentationsWhichSatisfies(IRequiredCapability rc, boolean skipCategoriesSubTree) {
        TwoColumnMatrix<IUPresentation, Object[]> found = new TwoColumnMatrix<IUPresentation, Object[]>();
        int i = 0;
        while (i < this.allIUPresentationMatrix.size()) {
            InstallableUnit iu;
            IUPresentation iup = this.allIUPresentationMatrix.getKey(i);
            if (!(iup == null || !(iu = iup.getInstallableUnit()).satisfies(rc) || skipCategoriesSubTree && this.allIUPresentationMatrix.getValue(i)[2] instanceof Categories)) {
                found.add(iup, this.allIUPresentationMatrix.getValue(i));
            }
            ++i;
        }
        return found;
    }

    public Diagnostic getDiagnostic() {
        return this.m_diagnostic;
    }

    public Exception getLastException() {
        return this.m_lastException;
    }

    @Override
    public Status getStatus() {
        return this.m_status;
    }

    public void load(Map<?, ?> options) throws IOException {
        Notification notification;
        block20: {
            boolean jobManagerReadyBeforeJobScheduled;
            block17: {
                block18: {
                    block19: {
                        java.net.URI location;
                        this.m_lastException = null;
                        if (this.isLoaded) {
                            return;
                        }
                        notification = this.setLoaded(true);
                        try {
                            location = new java.net.URI(this.getURI().opaquePart());
                        }
                        catch (URISyntaxException e) {
                            this.m_lastException = new Resource.IOWrappedException((Exception)e);
                            return;
                        }
                        this.isLoading = true;
                        MetadataRepositoryImpl repository = (MetadataRepositoryImpl)P2Factory.eINSTANCE.createMetadataRepository();
                        this.repoView = P2viewFactory.eINSTANCE.createMetadataRepositoryStructuredView(repository);
                        this.allIUPresentationMatrix.clear();
                        this.m_loadingJob = new RepositoryLoaderJob(repository, location, this.m_forceReload, this.repoView, this.allIUPresentationMatrix);
                        jobManagerReadyBeforeJobScheduled = !Job.getJobManager().isSuspended();
                        this.m_loadingJob.schedule();
                        this.m_loadingJob.join();
                        Exception e = this.m_loadingJob.getException();
                        if (e == null) break block17;
                        this.m_lastException = new Resource.IOWrappedException(e);
                        this.isLoading = false;
                        if (notification == null) break block18;
                        if (!options.containsKey(NOTIFICATION_KEY)) break block19;
                        Notification[] notificationRef = (Notification[])options.get(NOTIFICATION_KEY);
                        notificationRef[0] = notification;
                        break block18;
                    }
                    this.eNotify(notification);
                }
                this.setModified(false);
                return;
            }
            try {
                try {
                    if (jobManagerReadyBeforeJobScheduled) break block20;
                    this.m_lastException = new UnknownStatusException("Unknown repository status - loading job was scheduled while job manager was suspended");
                }
                catch (InterruptedException interruptedException) {
                    this.isLoading = false;
                    if (notification != null) {
                        if (options.containsKey(NOTIFICATION_KEY)) {
                            Notification[] notificationRef = (Notification[])options.get(NOTIFICATION_KEY);
                            notificationRef[0] = notification;
                        } else {
                            this.eNotify(notification);
                        }
                    }
                    this.setModified(false);
                }
            }
            catch (Throwable throwable) {
                this.isLoading = false;
                if (notification != null) {
                    if (options.containsKey(NOTIFICATION_KEY)) {
                        Notification[] notificationRef = (Notification[])options.get(NOTIFICATION_KEY);
                        notificationRef[0] = notification;
                    } else {
                        this.eNotify(notification);
                    }
                }
                this.setModified(false);
                throw throwable;
            }
        }
        this.isLoading = false;
        if (notification != null) {
            if (options.containsKey(NOTIFICATION_KEY)) {
                Notification[] notificationRef = (Notification[])options.get(NOTIFICATION_KEY);
                notificationRef[0] = notification;
            } else {
                this.eNotify(notification);
            }
        }
        this.setModified(false);
    }

    public MetadataRepository loadRepository(boolean force) {
        Exception loadException = null;
        Map<String, Notification[]> notificationCollector = Collections.singletonMap(NOTIFICATION_KEY, new Notification[1]);
        try {
            if (this.warnings != null) {
                this.warnings.clear();
            }
            if (this.errors != null) {
                this.errors.clear();
            }
            this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.WAITING));
            if (force) {
                this.unload();
                this.load(notificationCollector);
            } else if (!this.isLoaded()) {
                this.load(notificationCollector);
            }
            if (this.getLastException() != null) {
                throw this.getLastException();
            }
            EList contents = this.getContents();
            if (contents.size() != 1 || ((MetadataRepositoryStructuredView)contents.get(0)).getMetadataRepository().getLocation() == null) {
                throw new Exception(String.format("Unable to load repository %s", this.getURI().toString()));
            }
            MetadataRepository metadataRepository = ((MetadataRepositoryStructuredView)contents.get(0)).getMetadataRepository();
            return metadataRepository;
        }
        catch (Exception e) {
            loadException = e;
            return null;
        }
        finally {
            if (loadException != null) {
                this.getErrors().add((Object)new ResourceDiagnosticImpl(loadException.getMessage(), this.getURI().toString()));
                String message = GeneralUtils.trimmedOrNull(loadException.getMessage());
                if (message == null && MetadataRepositoryResourceImpl.unwrap(loadException) instanceof OperationCanceledException) {
                    message = "Repository loading was cancelled";
                }
                this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, message));
            } else {
                this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK));
            }
            Notification[] notificationRef = notificationCollector.get(NOTIFICATION_KEY);
            Notification notification = notificationRef[0];
            if (notification != null && this.eNotificationRequired()) {
                this.eNotify(notification);
            }
        }
    }

    public void save(Map<?, ?> options) throws IOException {
    }

    public synchronized void startAsynchronousLoad(boolean forceReload) {
        MetadataRepository myMDR;
        this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.WAITING));
        this.eNotify(this.setLoaded(this.isLoaded));
        String myLocation = this.getURI().toString();
        boolean mdrFinal = false;
        if (!forceReload && this.isLoaded() && !this.isLoading()) {
            myMDR = this.loadRepository(false);
            mdrFinal = true;
        } else {
            myMDR = null;
        }
        Aggregator aggregator = this.getAggregator();
        for (MetadataRepositoryReference mdr : aggregator.getAllMetadataRepositoryReferences(true)) {
            String refLocation = String.valueOf(mdr.getNature()) + ":" + mdr.getResolvedLocation();
            if (!myLocation.equals(refLocation)) continue;
            mdr.setMetadataRepository(myMDR);
            if (!mdrFinal) continue;
            mdr.onRepositoryLoad();
        }
        ResourceUtils.cleanUpResources(aggregator, false);
        if (mdrFinal) {
            return;
        }
        AsynchronousLoader lastLoader = this.m_asynchronousLoader;
        if (lastLoader == null || forceReload && !lastLoader.isForce()) {
            this.m_asynchronousLoader = new AsynchronousLoader("Loading " + myLocation, lastLoader, forceReload);
            this.m_asynchronousLoader.setUser(false);
            this.m_asynchronousLoader.schedule();
        }
    }

    protected void doUnload() {
        super.doUnload();
        this.m_forceReload = true;
    }

    private List<Object> findIU(List<Object> nodePath, Pattern iuIdPattern, VersionRange iuVersionRange, boolean forward) {
        List<Object> foundInSubTreePath = null;
        foundInSubTreePath = forward ? this.findIUInSubTree(nodePath, iuIdPattern, iuVersionRange) : this.findIUInNode(nodePath, iuIdPattern, iuVersionRange);
        if (foundInSubTreePath != null) {
            return foundInSubTreePath;
        }
        List<Object> nextNodePath = this.getNextNode(nodePath, forward);
        if (nextNodePath != null) {
            return this.findIU(nextNodePath, iuIdPattern, iuVersionRange, forward);
        }
        return null;
    }

    private List<Object> findIUInNode(List<Object> nodePath, Pattern iuIdPattern, VersionRange iuVersionRange) {
        IUPresentation iup;
        InstallableUnit iu;
        Object node = nodePath.get(nodePath.size() - 1);
        if (node instanceof IUPresentation && iuIdPattern.matcher((iu = (iup = (IUPresentation)node).getInstallableUnit()).getId()).find() && iuVersionRange.isIncluded(iu.getVersion())) {
            return nodePath;
        }
        return null;
    }

    private List<Object> findIUInSubTree(List<Object> nodePath, Pattern iuIdPattern, VersionRange iuVersionRange) {
        List<Object> foundIUPath = this.findIUInNode(nodePath, iuIdPattern, iuVersionRange);
        if (foundIUPath != null) {
            return foundIUPath;
        }
        Object node = nodePath.get(nodePath.size() - 1);
        if (node instanceof ChildrenProvider) {
            for (Object child : ((ChildrenProvider)node).getChildren()) {
                ArrayList<Object> childPath = new ArrayList<Object>(nodePath);
                childPath.add(child);
                foundIUPath = this.findIUInSubTree(childPath, iuIdPattern, iuVersionRange);
                if (foundIUPath == null) continue;
                return foundIUPath;
            }
        }
        return null;
    }

    private Aggregator getAggregator() {
        return (Aggregator)((Resource)this.getResourceSet().getResources().get(0)).getContents().get(0);
    }

    private List<Object> getFirstNode(Object[] startAfterPath, boolean forward) {
        List<Object> firstNodePath = new ArrayList<Object>();
        if (startAfterPath == null) {
            firstNodePath.add(this);
            firstNodePath.add(this.repoView);
            if (!forward) {
                firstNodePath = this.getLastChild(firstNodePath);
            }
        } else {
            firstNodePath = this.getNextNode(Arrays.asList(startAfterPath), forward);
        }
        return firstNodePath;
    }

    private List<Object> getLastChild(List<Object> nodePath) {
        if (!(nodePath.get(nodePath.size() - 1) instanceof ChildrenProvider)) {
            return nodePath;
        }
        EList children = ((ChildrenProvider)nodePath.get(nodePath.size() - 1)).getChildren();
        if (children == null || children.size() == 0) {
            return nodePath;
        }
        Object lastChild = children.get(children.size() - 1);
        ArrayList<Object> childPath = new ArrayList<Object>(nodePath);
        childPath.add(lastChild);
        return this.getLastChild(childPath);
    }

    private List<Object> getNextNode(List<Object> nodePath, boolean forward) {
        EList children;
        int nodeIndex;
        Object parent = nodePath.get(nodePath.size() - 2);
        if (forward) {
            EList children2;
            int nodeIndex2;
            if (parent instanceof ChildrenProvider && (nodeIndex2 = (children2 = ((ChildrenProvider)parent).getChildren()).indexOf(nodePath.get(nodePath.size() - 1))) < children2.size() - 1) {
                ArrayList<Object> nextNodePath = new ArrayList<Object>(nodePath);
                nextNodePath.remove(nodePath.size() - 1);
                nextNodePath.add(children2.get(nodeIndex2 + 1));
                return nextNodePath;
            }
            ArrayList<Object> parentPath = new ArrayList<Object>(nodePath);
            parentPath.remove(nodePath.size() - 1);
            return parentPath.size() > 2 ? this.getNextNode(parentPath, forward) : null;
        }
        if (parent instanceof ChildrenProvider && (nodeIndex = (children = ((ChildrenProvider)parent).getChildren()).indexOf(nodePath.get(nodePath.size() - 1))) > 0) {
            ArrayList<Object> nextNodePath = new ArrayList<Object>(nodePath);
            nextNodePath.remove(nodePath.size() - 1);
            nextNodePath.add(children.get(nodeIndex - 1));
            return this.getLastChild(nextNodePath);
        }
        ArrayList<Object> parentPath = new ArrayList<Object>(nodePath);
        parentPath.remove(nodePath.size() - 1);
        return parentPath.size() > 2 ? parentPath : null;
    }

    private void setStatus(Status status) {
        this.m_status = status;
    }

    class AsynchronousLoader
    extends Job {
        private Job m_replaceJob;
        private boolean m_force;

        public AsynchronousLoader(String name, Job replaceJob, boolean force) {
            super(name);
            this.m_replaceJob = replaceJob;
            this.m_force = force;
        }

        public boolean isForce() {
            return this.m_force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            class MonitorWatchDog
            extends Thread {
                private boolean m_done;
                private final /* synthetic */ IProgressMonitor val$monitor;

                MonitorWatchDog(IProgressMonitor iProgressMonitor) {
                    this.val$monitor = iProgressMonitor;
                }

                public void run() {
                    while (!this.m_done) {
                        if (this.val$monitor.isCanceled()) {
                            MetadataRepositoryResourceImpl.this.cancelLoadingJob();
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }

                public void setDone() {
                    this.m_done = true;
                }
            }
            MonitorWatchDog watchDog = new MonitorWatchDog(monitor);
            try {
                if (this.m_replaceJob != null) {
                    this.m_replaceJob.cancel();
                    this.m_replaceJob.join();
                }
                watchDog.start();
                MetadataRepository mdr = MetadataRepositoryResourceImpl.this.loadRepository(this.m_force);
                IStatus status = org.eclipse.core.runtime.Status.OK_STATUS;
                if (monitor.isCanceled()) {
                    status = org.eclipse.core.runtime.Status.CANCEL_STATUS;
                    mdr = null;
                }
                MetadataRepositoryResourceImpl metadataRepositoryResourceImpl = MetadataRepositoryResourceImpl.this;
                synchronized (metadataRepositoryResourceImpl) {
                    String myLocation = MetadataRepositoryResourceImpl.this.getURI().toString();
                    Aggregator aggregator = MetadataRepositoryResourceImpl.this.getAggregator();
                    Iterator iterator = aggregator.getAllMetadataRepositoryReferences(true).iterator();
                    while (iterator.hasNext()) {
                        MetadataRepositoryReference repoRef;
                        MetadataRepositoryReference metadataRepositoryReference = repoRef = (MetadataRepositoryReference)iterator.next();
                        synchronized (metadataRepositoryReference) {
                            String refLocation = String.valueOf(repoRef.getNature()) + ":" + repoRef.getResolvedLocation();
                            if (myLocation.equals(refLocation)) {
                                repoRef.setMetadataRepository(mdr);
                                repoRef.onRepositoryLoad();
                            }
                        }
                    }
                }
                iStatus = status;
            }
            catch (InterruptedException e) {
                try {
                    throw new RuntimeException("Repository load was interrupted");
                }
                catch (Throwable throwable) {
                    monitor.done();
                    watchDog.setDone();
                    MetadataRepositoryResourceImpl metadataRepositoryResourceImpl = MetadataRepositoryResourceImpl.this;
                    synchronized (metadataRepositoryResourceImpl) {
                        if (MetadataRepositoryResourceImpl.this.m_asynchronousLoader == this) {
                            MetadataRepositoryResourceImpl.this.m_asynchronousLoader = null;
                        }
                    }
                    throw throwable;
                }
            }
            monitor.done();
            watchDog.setDone();
            MetadataRepositoryResourceImpl metadataRepositoryResourceImpl = MetadataRepositoryResourceImpl.this;
            synchronized (metadataRepositoryResourceImpl) {
                if (MetadataRepositoryResourceImpl.this.m_asynchronousLoader == this) {
                    MetadataRepositoryResourceImpl.this.m_asynchronousLoader = null;
                }
            }
            return iStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RepositoryLoaderJob
    extends Job {
        private final MetadataRepositoryImpl repository;
        private final java.net.URI location;
        private boolean forceReload;
        private final MetadataRepositoryStructuredView repoView;
        private Exception exception;
        private TwoColumnMatrix<IUPresentation, Object[]> allIUMatrix;

        public RepositoryLoaderJob(MetadataRepositoryImpl repository, java.net.URI location, boolean forceReload, MetadataRepositoryStructuredView repoView, TwoColumnMatrix<IUPresentation, Object[]> allIUMap) {
            super("Repository Loader");
            this.repository = repository;
            this.location = location;
            this.forceReload = forceReload;
            this.repoView = repoView;
            this.allIUMatrix = allIUMap;
            this.setUser(false);
            this.setSystem(false);
            this.setPriority(20);
        }

        public Exception getException() {
            return this.exception;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block13: {
                this.exception = null;
                Logger log = Buckminster.getLogger();
                String msg = String.format("Loading repository %s", this.location);
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)msg, (int)100);
                try {
                    try {
                        MetadataRepositoryResourceImpl.this.m_loader.open(this.location, this.repository);
                        log.debug(msg, new Object[0]);
                        long start = TimeUtils.getNow();
                        SubMonitor loaderMonitor = subMon.newChild(100, 2);
                        if (!this.forceReload) {
                            MetadataRepositoryResourceImpl.this.m_loader.load((IProgressMonitor)loaderMonitor);
                        } else {
                            MetadataRepositoryResourceImpl.this.m_loader.reload((IProgressMonitor)loaderMonitor);
                        }
                        this.createStructuredView();
                        log.debug("Done. Took %s", new Object[]{TimeUtils.getFormattedDuration(start)});
                    }
                    catch (Exception e) {
                        this.exception = e;
                        log.error((Throwable)e, "Unable to load repository %s", new Object[]{this.location});
                        try {
                            MetadataRepositoryResourceImpl.this.m_loader.close();
                        }
                        catch (CoreException e2) {
                            this.exception = e2;
                            log.error((Throwable)e2, "Unable to close repository loader for %s", new Object[]{this.location});
                        }
                        MonitorUtils.done((IProgressMonitor)subMon);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        MetadataRepositoryResourceImpl.this.m_loader.close();
                    }
                    catch (CoreException e) {
                        this.exception = e;
                        log.error((Throwable)e, "Unable to close repository loader for %s", new Object[]{this.location});
                    }
                    MonitorUtils.done((IProgressMonitor)subMon);
                    throw throwable;
                }
                try {
                    MetadataRepositoryResourceImpl.this.m_loader.close();
                }
                catch (CoreException e) {
                    this.exception = e;
                    log.error((Throwable)e, "Unable to close repository loader for %s", new Object[]{this.location});
                }
                MonitorUtils.done((IProgressMonitor)subMon);
            }
            return org.eclipse.core.runtime.Status.OK_STATUS;
        }

        private void addIUsToMap(Object container, List<? extends IUPresentation> iuPresentations) {
            Object[] treePath = new Object[]{MetadataRepositoryResourceImpl.this, this.repoView, this.repoView.getInstallableUnitList(), container};
            for (IUPresentation iUPresentation : iuPresentations) {
                this.allIUMatrix.add(iUPresentation, treePath);
            }
        }

        private void createStructuredView() {
            Categories categoryContainer;
            this.repoView.setName(this.repository.getName());
            this.repoView.setInstallableUnitList(P2viewFactory.eINSTANCE.createInstallableUnits());
            HashMap<String, Map<Version, IUPresentation>> iuMap = new HashMap<String, Map<Version, IUPresentation>>();
            ArrayList<Category> categories = new ArrayList<Category>();
            ArrayList<Feature> features = new ArrayList<Feature>();
            ArrayList<Product> products = new ArrayList<Product>();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            ArrayList<Fragment> fragments = new ArrayList<Fragment>();
            ArrayList<OtherIU> miscellaneous = new ArrayList<OtherIU>();
            for (InstallableUnit iu : this.repository.getInstallableUnits()) {
                Object iuPresentation;
                switch (InstallableUnitUtils.getType(iu)) {
                    case CATEGORY: {
                        iuPresentation = P2viewFactory.eINSTANCE.createCategory(iu);
                        if (iuPresentation.isNested()) break;
                        categories.add((Category)iuPresentation);
                        break;
                    }
                    case FEATURE: {
                        iuPresentation = P2viewFactory.eINSTANCE.createFeature(iu);
                        features.add((Feature)iuPresentation);
                        break;
                    }
                    case PRODUCT: {
                        iuPresentation = P2viewFactory.eINSTANCE.createProduct(iu);
                        products.add((Product)iuPresentation);
                        break;
                    }
                    case BUNDLE: {
                        iuPresentation = P2viewFactory.eINSTANCE.createBundle(iu);
                        bundles.add((Bundle)iuPresentation);
                        break;
                    }
                    case FRAGMENT: {
                        iuPresentation = P2viewFactory.eINSTANCE.createFragment(iu);
                        fragments.add((Fragment)iuPresentation);
                        break;
                    }
                    default: {
                        iuPresentation = P2viewFactory.eINSTANCE.createOtherIU(iu);
                        miscellaneous.add((OtherIU)iuPresentation);
                    }
                }
                iuPresentation.setId(iu.getId());
                iuPresentation.setVersion(iu.getVersion());
                Object name = GeneralUtils.getLocalizedProperty(iu, "org.eclipse.equinox.p2.name");
                if (name == null || ((String)name).length() == 0) {
                    iuPresentation.setName(iu.getId());
                } else {
                    iuPresentation.setName((String)name);
                }
                if (name != null && ((String)name).startsWith("%")) {
                    name = null;
                }
                if (InstallableUnitUtils.getType(iu) == InstallableUnitType.CATEGORY || iu.getVersion() == null) {
                    iuPresentation.setLabel((String)(name != null && ((String)name).length() > 0 ? name : iu.getId()));
                } else {
                    iuPresentation.setLabel(String.valueOf(iu.getId()) + " / " + GeneralUtils.stringifyVersion(iu.getVersion()) + (name != null && ((String)name).length() > 0 ? " (" + (String)name + ")" : ""));
                }
                iuPresentation.setDescription(GeneralUtils.getLocalizedProperty(iu, "org.eclipse.equinox.p2.description"));
                HashMap<Version, Object> versionMap = (HashMap<Version, Object>)iuMap.get(iu.getId());
                if (versionMap == null) {
                    versionMap = new HashMap<Version, Object>();
                    iuMap.put(iu.getId(), versionMap);
                }
                versionMap.put(iu.getVersion(), iuPresentation);
            }
            if (categories.size() > 0) {
                Collections.sort(categories, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullCategoryContainer().getCategories().addAll(categories);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getCategoryContainer(), categories);
            }
            if (features.size() > 0) {
                Collections.sort(features, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullFeatureContainer().getFeatures().addAll(features);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getFeatureContainer(), features);
            }
            if (products.size() > 0) {
                Collections.sort(products, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullProductContainer().getProducts().addAll(products);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getProductContainer(), products);
            }
            if (bundles.size() > 0) {
                Collections.sort(bundles, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullBundleContainer().getBundles().addAll(bundles);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getBundleContainer(), bundles);
            }
            if (fragments.size() > 0) {
                Collections.sort(fragments, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullFragmentContainer().getFragments().addAll(fragments);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getFragmentContainer(), fragments);
            }
            if (miscellaneous.size() > 0) {
                Collections.sort(miscellaneous, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullMiscellaneousContainer().getOthers().addAll(miscellaneous);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getMiscellaneousContainer(), miscellaneous);
            }
            if ((categoryContainer = this.repoView.getInstallableUnitList().getCategoryContainer()) != null) {
                for (Category category : categoryContainer.getCategories()) {
                    this.exploreCategory(category, iuMap);
                }
            }
            ArrayList<Property> propList = new ArrayList<Property>();
            for (Map.Entry property : this.repository.getPropertyMap()) {
                propList.add(AggregatorFactory.eINSTANCE.createProperty((String)property.getKey(), (String)property.getValue()));
            }
            if (propList.size() > 0) {
                this.repoView.setProperties(P2viewFactory.eINSTANCE.createProperties());
                Collections.sort(propList);
                this.repoView.getProperties().getPropertyList().addAll(propList);
            }
            this.repoView.setLoaded(true);
            MetadataRepositoryResourceImpl.this.getContents().add((Object)((EObject)this.repoView));
            Aggregator aggregator = ResourceUtils.getAggregator(MetadataRepositoryResourceImpl.this.getResourceSet());
            if (aggregator != null) {
                for (MetadataRepositoryReference mdrReference : aggregator.getAllMetadataRepositoryReferences(true)) {
                    String refLocation = mdrReference.getLocation();
                    if (refLocation != null && refLocation.endsWith("/")) {
                        refLocation = refLocation.substring(0, refLocation.length() - 1);
                    }
                    if (!this.repository.getLocation().toString().equals(refLocation)) continue;
                    mdrReference.setLocation(mdrReference.getLocation());
                }
            }
        }

        private void exploreCategory(Category category, Map<String, Map<Version, IUPresentation>> iuMap) {
            ArrayList<Category> categories = new ArrayList<Category>();
            ArrayList<Feature> features = new ArrayList<Feature>();
            ArrayList<Product> products = new ArrayList<Product>();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            ArrayList<Fragment> fragments = new ArrayList<Fragment>();
            int idx = this.allIUMatrix.indexOf(category);
            Object[] oldTreePath = this.allIUMatrix.getValue(idx);
            int len = oldTreePath.length;
            Object[] categoryTreePath = new Object[len + 1];
            System.arraycopy(oldTreePath, 0, categoryTreePath, 0, len);
            categoryTreePath[len] = category;
            for (IRequiredCapability requiredCapability : category.getInstallableUnit().getRequiredCapabilityList()) {
                IUPresentation iuPresentation;
                Map<Version, IUPresentation> iuCandidates;
                VersionRange range = requiredCapability.getRange();
                if (!range.getMinimum().equals((Object)range.getMaximum()) || !range.getIncludeMinimum() || !range.getIncludeMaximum() || (iuCandidates = iuMap.get(requiredCapability.getName())) == null || (iuPresentation = iuCandidates.get(range.getMinimum())) == null) continue;
                this.allIUMatrix.add(++idx, iuPresentation, categoryTreePath);
                if (iuPresentation instanceof Category) {
                    categories.add((Category)iuPresentation);
                    this.exploreCategory((Category)iuPresentation, iuMap);
                    continue;
                }
                if (iuPresentation instanceof Feature) {
                    features.add((Feature)iuPresentation);
                    continue;
                }
                if (iuPresentation instanceof Product) {
                    products.add((Product)iuPresentation);
                    continue;
                }
                if (iuPresentation instanceof Fragment) {
                    fragments.add((Fragment)iuPresentation);
                    continue;
                }
                if (!(iuPresentation instanceof Bundle)) continue;
                bundles.add((Bundle)iuPresentation);
            }
            if (categories.size() > 0) {
                Collections.sort(categories, IUPresentation.COMPARATOR);
                category.getNotNullCategoryContainer().getCategories().addAll(categories);
            }
            if (features.size() > 0) {
                Collections.sort(features, IUPresentation.COMPARATOR);
                category.getNotNullFeatureContainer().getFeatures().addAll(features);
            }
            if (products.size() > 0) {
                Collections.sort(products, IUPresentation.COMPARATOR);
                category.getNotNullProductContainer().getProducts().addAll(products);
            }
            if (bundles.size() > 0) {
                Collections.sort(bundles, IUPresentation.COMPARATOR);
                category.getNotNullBundleContainer().getBundles().addAll(bundles);
            }
            if (fragments.size() > 0) {
                Collections.sort(fragments, IUPresentation.COMPARATOR);
                category.getNotNullFragmentContainer().getFragments().addAll(fragments);
            }
        }
    }

    class UnknownStatusException
    extends Exception {
        UnknownStatusException(String message) {
            super(message);
        }
    }
}

