/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.p2.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.buckminster.aggregator.loader.IRepositoryLoader;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.buckminster.aggregator.p2.impl.MetadataRepositoryImpl;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class P2RepositoryLoader
implements IRepositoryLoader {
    private URI m_location;
    private MetadataRepositoryImpl m_repository;
    private Buckminster m_bucky = Buckminster.getDefault();
    private IMetadataRepositoryManager mdrMgr;
    private static final Query QUERY_ALL_IUS = new MatchQuery(){

        public boolean isMatch(Object candidate) {
            return candidate instanceof IInstallableUnit;
        }
    };

    public void close() {
        this.m_bucky.ungetService((Object)this.mdrMgr);
    }

    public IArtifactRepository getArtifactRepository(IMetadataRepository mdr, IProgressMonitor monitor) throws CoreException {
        Buckminster bucky = Buckminster.getDefault();
        IArtifactRepositoryManager arMgr = null;
        try {
            arMgr = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
            IArtifactRepository iArtifactRepository = arMgr.loadRepository(mdr.getLocation(), monitor);
            return iArtifactRepository;
        }
        finally {
            bucky.ungetService((Object)arMgr);
        }
    }

    public void load(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, false);
    }

    public void open(URI location, MetadataRepositoryImpl mdr) throws CoreException {
        this.m_location = location;
        this.m_repository = mdr;
        this.mdrMgr = (IMetadataRepositoryManager)this.m_bucky.getService(IMetadataRepositoryManager.class);
    }

    public void reload(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, true);
    }

    private void load(IProgressMonitor monitor, boolean avoidCache) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IMetadataRepository repo = null;
        int i = 2;
        while (i >= 0) {
            try {
                if (avoidCache) {
                    if (this.mdrMgr.contains(this.m_location)) {
                        repo = this.mdrMgr.refreshRepository(this.m_location, (IProgressMonitor)subMon.newChild(80));
                        break;
                    }
                    try {
                        this.mdrMgr.refreshRepository(this.m_location, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (ProvisionException provisionException) {
                        // empty catch block
                    }
                    repo = this.mdrMgr.loadRepository(this.m_location, (IProgressMonitor)subMon.newChild(80));
                    break;
                }
                repo = this.mdrMgr.loadRepository(this.m_location, (IProgressMonitor)subMon.newChild(80));
                break;
            }
            catch (ProvisionException e) {
                Throwable t = e.getCause();
                if (i > 0 && t instanceof IOException && t.getMessage() != null && t.getMessage().contains("SAX parser service")) {
                    Buckminster.getLogger().warning("Error loading repository: %s Trying to recover (attempts remaining: %d)", new Object[]{t.getMessage(), i});
                    try {
                        Thread.sleep(1000 * (3 - i));
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    throw e;
                }
                --i;
            }
        }
        this.m_repository.setName(repo.getName());
        this.m_repository.setLocation(repo.getLocation());
        this.m_repository.setDescription(repo.getDescription());
        this.m_repository.setProvider(repo.getProvider());
        this.m_repository.setType(repo.getType());
        this.m_repository.setVersion(repo.getVersion());
        this.m_repository.getPropertyMap().putAll(repo.getProperties());
        Collector collector = repo.query(QUERY_ALL_IUS, new Collector(), (IProgressMonitor)subMon.newChild(20));
        Iterator itor = collector.iterator();
        ArrayList<InstallableUnit> ius = new ArrayList<InstallableUnit>();
        while (itor.hasNext()) {
            ius.add(InstallableUnitImpl.importToModel((IInstallableUnit)itor.next()));
        }
        Collections.sort(ius);
        this.m_repository.getInstallableUnits().addAll(ius);
        this.m_repository.addRepositoryReferences(this.mdrMgr, repo);
    }
}

