/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AccessibleByteArrayOutputStream
extends ByteArrayOutputStream {
    private final int m_maxSize;

    public AccessibleByteArrayOutputStream() {
        this.m_maxSize = -1;
    }

    public AccessibleByteArrayOutputStream(int size) {
        super(size);
        this.m_maxSize = -1;
    }

    public AccessibleByteArrayOutputStream(int size, int maxSize) {
        super(size);
        this.m_maxSize = maxSize;
    }

    public void close() throws IOException {
        this.count = 0;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        if (this.m_maxSize > 0 && this.count >= this.m_maxSize) {
            throw new IllegalStateException("Maximum size " + Integer.valueOf(this.m_maxSize) + " exceeded");
        }
    }

    public void write(int b) {
        super.write(b);
        if (this.m_maxSize > 0 && this.count >= this.m_maxSize) {
            throw new IllegalStateException("Maximum size " + Integer.valueOf(this.m_maxSize) + " exceeded");
        }
    }
}

