/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.aggregator.AggregatorPlugin;
import org.eclipse.emf.common.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CapabilityNamespace {
    IU("_UI_Capability_IU_type"),
    TYPE("_UI_Capability_Type_type"),
    LOCALIZATION("_UI_Capability_Localization_type"),
    FLAVOR("_UI_Capability_Flavor_type"),
    FEATURE("_UI_Capability_Feature_type"),
    BUNDLE("_UI_Capability_Bundle_type"),
    FRAGMENT("_UI_Capability_Fragment_type"),
    JAVA_PACKAGE("_UI_Capability_JavaPackage_type"),
    TOOLING("_UI_Capability_Tooling_type"),
    UNKNOWN("_UI_Capability_Unknown_type");

    private static Map<String, CapabilityNamespace> m_namespaceMap;
    private static Map<Pattern, CapabilityNamespace> m_namespaceMatchMap;
    private String m_label;

    static {
        m_namespaceMap = new HashMap<String, CapabilityNamespace>();
        m_namespaceMap.put("org.eclipse.equinox.p2.iu", IU);
        m_namespaceMap.put("org.eclipse.equinox.p2.eclipse.type", TYPE);
        m_namespaceMap.put("org.eclipse.equinox.p2.localization", LOCALIZATION);
        m_namespaceMap.put("org.eclipse.equinox.p2.flavor", FLAVOR);
        m_namespaceMap.put("org.eclipse.update.feature", FEATURE);
        m_namespaceMap.put("osgi.bundle", BUNDLE);
        m_namespaceMap.put("osgi.fragment", FRAGMENT);
        m_namespaceMap.put("java.package", JAVA_PACKAGE);
        m_namespaceMatchMap = new HashMap<Pattern, CapabilityNamespace>();
        m_namespaceMatchMap.put(Pattern.compile("^tooling.*"), TOOLING);
    }

    public static CapabilityNamespace byId(String namespaceId) {
        CapabilityNamespace namespace = m_namespaceMap.get(namespaceId);
        if (namespace == null) {
            for (Pattern pattern : m_namespaceMatchMap.keySet()) {
                if (!pattern.matcher(namespaceId).matches()) continue;
                return m_namespaceMatchMap.get(pattern);
            }
        }
        if (namespace == null) {
            namespace = UNKNOWN;
            namespace.m_label = String.valueOf(namespaceId) + ":";
        }
        return namespace;
    }

    private static ResourceLocator getResourceLocator() {
        return AggregatorPlugin.INSTANCE;
    }

    private CapabilityNamespace(String label) {
        this.m_label = CapabilityNamespace.getResourceLocator().getString(label);
    }

    public String getLabel() {
        return this.m_label;
    }
}

