/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.IAggregatorConstants;
import org.eclipse.buckminster.aggregator.InstallableUnitType;
import org.eclipse.buckminster.aggregator.Status;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;

public class InstallableUnitUtils {
    private static final Pattern proxyFragmentPattern = Pattern.compile("^//@metadataRepository/@installableUnits\\[id='([^']*)',version='([^']*)'\\]$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getStatus(InstallableUnit iu) {
        InstallableUnit installableUnit = iu;
        synchronized (installableUnit) {
            return Trivial.trim((String)iu.getId()) != null ? AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK) : AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
    }

    public static InstallableUnitType getType(InstallableUnit iu) {
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category"))) {
            return InstallableUnitType.CATEGORY;
        }
        if (iu.getId().endsWith(".feature.group")) {
            return InstallableUnitType.FEATURE;
        }
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.group"))) {
            return InstallableUnitType.PRODUCT;
        }
        if (InstallableUnitUtils.isOSGiFragment(iu)) {
            return InstallableUnitType.FRAGMENT;
        }
        if (InstallableUnitUtils.isOSGiBundle(iu)) {
            return InstallableUnitType.BUNDLE;
        }
        return InstallableUnitType.OTHER;
    }

    public static VersionedName getVersionedName(InstallableUnit iu) {
        if (((EObject)iu).eIsProxy()) {
            return InstallableUnitUtils.getVersionedNameFromProxy(iu);
        }
        return new VersionedName(iu.getId(), iu.getVersion());
    }

    public static VersionedName getVersionedNameFromProxy(InstallableUnit iu) {
        URI uri = ((InternalEObject)iu).eProxyURI();
        if (uri == null) {
            return null;
        }
        String frag = uri.fragment();
        if (frag == null) {
            return null;
        }
        Matcher m = proxyFragmentPattern.matcher(frag);
        return m.matches() ? new VersionedName(m.group(1), m.group(2)) : null;
    }

    private static boolean isOSGiBundle(InstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilityList()) {
            if (!"org.eclipse.equinox.p2.eclipse.type".equals(rc.getNamespace()) || !IAggregatorConstants.CAPABILITY_TYPE_BUNDLE.equals(rc.getName()) && !"source".equals(rc.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isOSGiFragment(InstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilityList()) {
            if (!"osgi.fragment".equals(rc.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

