/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.MetadataRepositoryReference;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.p2.P2Factory;
import org.eclipse.buckminster.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.buckminster.aggregator.util.AggregatorResourceImpl;
import org.eclipse.buckminster.aggregator.util.InstallableUnitUtils;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ResourceUtils {
    public static void cleanUpResources(Aggregator aggregator) {
        ResourceUtils.cleanUpResources(aggregator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpResources(Aggregator aggregator, boolean updateMarkers) {
        ResourceSet topSet;
        Resource topResource = ((EObject)aggregator).eResource();
        ResourceSet resourceSet = topSet = topResource.getResourceSet();
        synchronized (resourceSet) {
            HashSet<Resource> referencedResources = new HashSet<Resource>();
            referencedResources.add(topResource);
            for (Contribution contribution : aggregator.getContributions()) {
                for (MappedRepository mappedRepository : contribution.getRepositories()) {
                    if (mappedRepository.isBranchEnabled()) {
                        if (mappedRepository.getResolvedLocation() == null) continue;
                        URI repoURI = URI.createGenericURI((String)mappedRepository.getNature(), (String)mappedRepository.getResolvedLocation(), null);
                        referencedResources.add(topSet.getResource(repoURI, false));
                        continue;
                    }
                    for (MappedUnit unit : mappedRepository.getUnits(false)) {
                        InstallableUnit originalIU = unit.getInstallableUnit(false);
                        if (originalIU == null || ((EObject)originalIU).eIsProxy()) continue;
                        unit.setInstallableUnit(P2Factory.eINSTANCE.createInstallableUnitProxy(mappedRepository.getNature(), mappedRepository.getLocation(), InstallableUnitUtils.getVersionedName(originalIU)));
                    }
                    if (mappedRepository.getMetadataRepository(false) == null) continue;
                    mappedRepository.setMetadataRepository(null);
                }
            }
            for (MetadataRepositoryReference repoRef : aggregator.getValidationRepositories()) {
                if (repoRef.isBranchEnabled()) {
                    if (repoRef.getResolvedLocation() == null) continue;
                    URI repoURI = URI.createGenericURI((String)repoRef.getNature(), (String)repoRef.getResolvedLocation(), null);
                    referencedResources.add(topSet.getResource(repoURI, false));
                    continue;
                }
                if (repoRef.getMetadataRepository(false) == null) continue;
                repoRef.setMetadataRepository(null);
            }
            Iterator allResources = topSet.getResources().iterator();
            while (allResources.hasNext()) {
                Resource res = (Resource)allResources.next();
                if (referencedResources.contains(res)) continue;
                if (res instanceof MetadataRepositoryResourceImpl) {
                    ((MetadataRepositoryResourceImpl)res).cancelLoadingJob();
                }
                allResources.remove();
            }
        }
        if (updateMarkers) {
            ((AggregatorResourceImpl)topResource).analyzeResource();
        }
    }

    public static Aggregator getAggregator(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        EList resources = resourceSet.getResources();
        Resource aggregatorResource = null;
        for (Resource resource : resources) {
            if (!(resource instanceof AggregatorResourceImpl)) continue;
            aggregatorResource = resource;
            break;
        }
        return aggregatorResource == null ? null : (Aggregator)aggregatorResource.getContents().get(0);
    }

    public static MetadataRepository getMetadataRepository(MetadataRepositoryReference repoRef) throws CoreException {
        MetadataRepository mdr = repoRef.getMetadataRepository();
        if (mdr == null) {
            Resource resource = ((EObject)repoRef).eResource();
            if (resource != null && resource instanceof MetadataRepositoryResourceImpl && ((MetadataRepositoryResourceImpl)resource).getLastException() != null) {
                throw BuckminsterException.wrap((Throwable)((MetadataRepositoryResourceImpl)resource).getLastException());
            }
            throw BuckminsterException.fromMessage((String)("Error loading repository " + repoRef.getResolvedLocation()), (Object[])new Object[0]);
        }
        return mdr;
    }

    public static void loadResourceForMappedRepository(MetadataRepositoryReference repoRef) {
        repoRef.startRepositoryLoad(false);
    }
}

