/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.buckminster.aggregator.util.ExtendedListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoColumnMatrix<K, V> {
    List<K> m_keys;
    List<V> m_values;

    public TwoColumnMatrix() {
        this(10);
    }

    public TwoColumnMatrix(int size) {
        this.m_keys = new ArrayList<K>(size);
        this.m_values = new ArrayList<V>(size);
    }

    public void add(int index, K key, V value) {
        this.m_keys.add(index, key);
        this.m_values.add(index, value);
    }

    public void add(int index, MatrixEntry entry) {
        this.add(index, entry.getKey(), entry.getValue());
    }

    public void add(K key, V value) {
        this.m_keys.add(key);
        this.m_values.add(value);
    }

    public void add(MatrixEntry entry) {
        this.add(entry.getKey(), entry.getValue());
    }

    public void addAll(TwoColumnMatrix<K, V> matrix) {
        this.m_keys.addAll(matrix.m_keys);
        this.m_values.addAll(matrix.m_values);
    }

    public void clear() {
        this.m_keys.clear();
        this.m_values.clear();
    }

    public List<MatrixEntry> getEntries() {
        ArrayList<MatrixEntry> entries = new ArrayList<MatrixEntry>(this.size());
        int i = 0;
        while (i < this.size()) {
            entries.add(this.getEntry(i));
            ++i;
        }
        return entries;
    }

    public MatrixEntry getEntry(int index) {
        return index < this.size() ? new MatrixEntry(this.m_keys.get(index), this.m_values.get(index)) : null;
    }

    public K getKey(int index) {
        return this.m_keys.get(index);
    }

    public V getValue(int index) {
        return this.m_values.get(index);
    }

    public int indexOf(K key) {
        return this.m_keys.indexOf(key);
    }

    public void remove(int index) {
        this.m_keys.remove(index);
        this.m_values.remove(index);
    }

    public void set(int index, K key, V value) {
        this.m_keys.set(index, key);
        this.m_values.set(index, value);
    }

    public void set(int index, MatrixEntry entry) {
        this.set(index, entry.getKey(), entry.getValue());
    }

    public int size() {
        return this.m_keys.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MatrixEntry {
        K m_key;
        V m_value;

        public MatrixEntry(K key, V value) {
            this.m_key = key;
            this.m_value = value;
        }

        public K getKey() {
            return this.m_key;
        }

        public V getValue() {
            return this.m_value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MatrixIterator
    implements ExtendedListIterator<MatrixEntry> {
        private TwoColumnMatrix<K, V> m_matrix;
        private int m_index = -1;

        public MatrixIterator(TwoColumnMatrix<K, V> matrix) {
            this.m_matrix = matrix;
        }

        public void add(MatrixEntry entry) {
            this.m_matrix.add(this.m_index++, entry);
        }

        @Override
        public MatrixEntry first() {
            this.m_index = 0;
            return this.m_matrix.getEntry(this.m_index);
        }

        @Override
        public boolean hasNext() {
            return this.m_index < this.m_matrix.size() - 1;
        }

        public boolean hasPrevious() {
            return this.m_index > 0;
        }

        @Override
        public MatrixEntry last() {
            this.m_index = this.m_matrix.size() - 1;
            return this.m_matrix.getEntry(this.m_index);
        }

        @Override
        public MatrixEntry next() {
            ++this.m_index;
            if (this.m_index >= this.m_matrix.size()) {
                throw new NoSuchElementException();
            }
            return this.m_matrix.getEntry(this.m_index);
        }

        public int nextIndex() {
            return this.m_index + 1;
        }

        public MatrixEntry previous() {
            --this.m_index;
            if (this.m_index < 0) {
                throw new NoSuchElementException();
            }
            return this.m_matrix.getEntry(this.m_index);
        }

        public int previousIndex() {
            return this.m_index - 1;
        }

        @Override
        public void remove() {
            this.m_matrix.remove(this.m_index);
        }

        public void set(MatrixEntry entry) {
            this.m_matrix.set(this.m_index, entry);
        }
    }
}

