/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.eclipse.buckminster.aggregator.util.UriUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriIterator
implements Iterator<URI> {
    private final URI m_root;
    private final URI[] m_uris;
    private final Pattern m_excludePattern;
    private int m_index;

    public UriIterator(URI root, Pattern excludePattern, IProgressMonitor monitor) throws CoreException {
        this.m_uris = UriUtils.list(UriUtils.appendTrailingSlash(root), monitor);
        this.m_index = -1;
        this.m_excludePattern = excludePattern;
        this.m_root = root;
        this.positionNext();
    }

    public UriIterator(URI root, Pattern excludePattern, URI[] uris) {
        this.m_uris = uris;
        this.m_index = -1;
        this.m_excludePattern = excludePattern;
        this.m_root = root;
        this.positionNext();
    }

    public URI getRoot() {
        return this.m_root;
    }

    public URI[] getURIs() {
        return this.m_uris;
    }

    @Override
    public boolean hasNext() {
        return this.m_index < this.m_uris.length;
    }

    @Override
    public URI next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        URI nextURL = this.m_uris[this.m_index];
        this.positionNext();
        return nextURL;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.m_uris.length;
    }

    private void positionNext() {
        if (this.m_excludePattern == null) {
            ++this.m_index;
        } else {
            int top = this.m_uris.length;
            while (++this.m_index < top && this.m_excludePattern.matcher(this.m_uris[this.m_index].toString()).matches()) {
            }
        }
    }
}

